/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.flowable.internal.operators;

import hu.akarnokd.reactivestreams.extensions.ConditionalSubscriber;
import io.reactivex.common.RxJavaCommonPlugins;
import io.reactivex.common.annotations.Nullable;
import io.reactivex.common.exceptions.CompositeException;
import io.reactivex.common.exceptions.Exceptions;
import io.reactivex.common.functions.Action;
import io.reactivex.common.functions.Consumer;
import io.reactivex.flowable.Flowable;
import io.reactivex.flowable.internal.operators.AbstractFlowableWithUpstream;
import io.reactivex.flowable.internal.subscribers.BasicFuseableConditionalSubscriber;
import io.reactivex.flowable.internal.subscribers.BasicFuseableSubscriber;
import org.reactivestreams.Subscriber;

public final class FlowableDoOnEach<T>
extends AbstractFlowableWithUpstream<T, T> {
    final Consumer<? super T> onNext;
    final Consumer<? super Throwable> onError;
    final Action onComplete;
    final Action onAfterTerminate;

    public FlowableDoOnEach(Flowable<T> source, Consumer<? super T> onNext, Consumer<? super Throwable> onError, Action onComplete, Action onAfterTerminate) {
        super(source);
        this.onNext = onNext;
        this.onError = onError;
        this.onComplete = onComplete;
        this.onAfterTerminate = onAfterTerminate;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        if (s instanceof ConditionalSubscriber) {
            this.source.subscribe(new DoOnEachConditionalSubscriber<T>((ConditionalSubscriber)s, this.onNext, this.onError, this.onComplete, this.onAfterTerminate));
        } else {
            this.source.subscribe(new DoOnEachSubscriber<T>(s, this.onNext, this.onError, this.onComplete, this.onAfterTerminate));
        }
    }

    static final class DoOnEachConditionalSubscriber<T>
    extends BasicFuseableConditionalSubscriber<T, T> {
        final Consumer<? super T> onNext;
        final Consumer<? super Throwable> onError;
        final Action onComplete;
        final Action onAfterTerminate;

        DoOnEachConditionalSubscriber(ConditionalSubscriber<? super T> actual, Consumer<? super T> onNext, Consumer<? super Throwable> onError, Action onComplete, Action onAfterTerminate) {
            super(actual);
            this.onNext = onNext;
            this.onError = onError;
            this.onComplete = onComplete;
            this.onAfterTerminate = onAfterTerminate;
        }

        public void onNext(T t) {
            if (this.done) {
                return;
            }
            if (this.sourceMode != 0) {
                this.actual.onNext(null);
                return;
            }
            try {
                this.onNext.accept(t);
            }
            catch (Throwable e) {
                this.fail(e);
                return;
            }
            this.actual.onNext(t);
        }

        public boolean tryOnNext(T t) {
            if (this.done) {
                return false;
            }
            try {
                this.onNext.accept(t);
            }
            catch (Throwable e) {
                this.fail(e);
                return false;
            }
            return this.actual.tryOnNext(t);
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaCommonPlugins.onError((Throwable)t);
                return;
            }
            this.done = true;
            boolean relay = true;
            try {
                this.onError.accept((Object)t);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal((Throwable)e);
                this.actual.onError((Throwable)new CompositeException(new Throwable[]{t, e}));
                relay = false;
            }
            if (relay) {
                this.actual.onError(t);
            }
            try {
                this.onAfterTerminate.run();
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal((Throwable)e);
                RxJavaCommonPlugins.onError((Throwable)e);
            }
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            try {
                this.onComplete.run();
            }
            catch (Throwable e) {
                this.fail(e);
                return;
            }
            this.done = true;
            this.actual.onComplete();
            try {
                this.onAfterTerminate.run();
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal((Throwable)e);
                RxJavaCommonPlugins.onError((Throwable)e);
            }
        }

        public int requestFusion(int mode) {
            return this.transitiveBoundaryFusion(mode);
        }

        @Nullable
        public T poll() throws Throwable {
            Object v = this.qs.poll();
            if (v != null) {
                try {
                    this.onNext.accept(v);
                }
                finally {
                    this.onAfterTerminate.run();
                }
            } else if (this.sourceMode == 1) {
                this.onComplete.run();
                this.onAfterTerminate.run();
            }
            return (T)v;
        }
    }

    static final class DoOnEachSubscriber<T>
    extends BasicFuseableSubscriber<T, T> {
        final Consumer<? super T> onNext;
        final Consumer<? super Throwable> onError;
        final Action onComplete;
        final Action onAfterTerminate;

        DoOnEachSubscriber(Subscriber<? super T> actual, Consumer<? super T> onNext, Consumer<? super Throwable> onError, Action onComplete, Action onAfterTerminate) {
            super(actual);
            this.onNext = onNext;
            this.onError = onError;
            this.onComplete = onComplete;
            this.onAfterTerminate = onAfterTerminate;
        }

        public void onNext(T t) {
            if (this.done) {
                return;
            }
            if (this.sourceMode != 0) {
                this.actual.onNext(null);
                return;
            }
            try {
                this.onNext.accept(t);
            }
            catch (Throwable e) {
                this.fail(e);
                return;
            }
            this.actual.onNext(t);
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaCommonPlugins.onError((Throwable)t);
                return;
            }
            this.done = true;
            boolean relay = true;
            try {
                this.onError.accept((Object)t);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal((Throwable)e);
                this.actual.onError((Throwable)new CompositeException(new Throwable[]{t, e}));
                relay = false;
            }
            if (relay) {
                this.actual.onError(t);
            }
            try {
                this.onAfterTerminate.run();
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal((Throwable)e);
                RxJavaCommonPlugins.onError((Throwable)e);
            }
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            try {
                this.onComplete.run();
            }
            catch (Throwable e) {
                this.fail(e);
                return;
            }
            this.done = true;
            this.actual.onComplete();
            try {
                this.onAfterTerminate.run();
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal((Throwable)e);
                RxJavaCommonPlugins.onError((Throwable)e);
            }
        }

        public int requestFusion(int mode) {
            return this.transitiveBoundaryFusion(mode);
        }

        @Nullable
        public T poll() throws Throwable {
            Object v = this.qs.poll();
            if (v != null) {
                try {
                    this.onNext.accept(v);
                }
                finally {
                    this.onAfterTerminate.run();
                }
            } else if (this.sourceMode == 1) {
                this.onComplete.run();
                this.onAfterTerminate.run();
            }
            return (T)v;
        }
    }
}

