/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.flowable.internal.operators;

import hu.akarnokd.reactivestreams.extensions.RelaxedSubscriber;
import io.reactivex.common.RxJavaCommonPlugins;
import io.reactivex.common.exceptions.Exceptions;
import io.reactivex.common.functions.Action;
import io.reactivex.common.functions.Consumer;
import io.reactivex.common.functions.LongConsumer;
import io.reactivex.flowable.Flowable;
import io.reactivex.flowable.internal.operators.AbstractFlowableWithUpstream;
import io.reactivex.flowable.internal.subscriptions.EmptySubscription;
import io.reactivex.flowable.internal.subscriptions.SubscriptionHelper;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableDoOnLifecycle<T>
extends AbstractFlowableWithUpstream<T, T> {
    private final Consumer<? super Subscription> onSubscribe;
    private final LongConsumer onRequest;
    private final Action onCancel;

    public FlowableDoOnLifecycle(Flowable<T> source, Consumer<? super Subscription> onSubscribe, LongConsumer onRequest, Action onCancel) {
        super(source);
        this.onSubscribe = onSubscribe;
        this.onRequest = onRequest;
        this.onCancel = onCancel;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        this.source.subscribe(new SubscriptionLambdaSubscriber<T>(s, this.onSubscribe, this.onRequest, this.onCancel));
    }

    static final class SubscriptionLambdaSubscriber<T>
    implements RelaxedSubscriber<T>,
    Subscription {
        final Subscriber<? super T> actual;
        final Consumer<? super Subscription> onSubscribe;
        final LongConsumer onRequest;
        final Action onCancel;
        Subscription s;

        SubscriptionLambdaSubscriber(Subscriber<? super T> actual, Consumer<? super Subscription> onSubscribe, LongConsumer onRequest, Action onCancel) {
            this.actual = actual;
            this.onSubscribe = onSubscribe;
            this.onCancel = onCancel;
            this.onRequest = onRequest;
        }

        public void onSubscribe(Subscription s) {
            try {
                this.onSubscribe.accept((Object)s);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal((Throwable)e);
                s.cancel();
                this.s = SubscriptionHelper.CANCELLED;
                EmptySubscription.error(e, this.actual);
                return;
            }
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            this.actual.onNext(t);
        }

        public void onError(Throwable t) {
            if (this.s != SubscriptionHelper.CANCELLED) {
                this.actual.onError(t);
            } else {
                RxJavaCommonPlugins.onError((Throwable)t);
            }
        }

        public void onComplete() {
            if (this.s != SubscriptionHelper.CANCELLED) {
                this.actual.onComplete();
            }
        }

        public void request(long n) {
            try {
                this.onRequest.accept(n);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal((Throwable)e);
                RxJavaCommonPlugins.onError((Throwable)e);
            }
            this.s.request(n);
        }

        public void cancel() {
            try {
                this.onCancel.run();
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal((Throwable)e);
                RxJavaCommonPlugins.onError((Throwable)e);
            }
            this.s.cancel();
        }
    }
}

