/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.flowable.internal.operators;

import hu.akarnokd.reactivestreams.extensions.RelaxedSubscriber;
import io.reactivex.flowable.Flowable;
import io.reactivex.flowable.internal.operators.AbstractFlowableWithUpstream;
import io.reactivex.flowable.internal.subscriptions.DeferredScalarSubscription;
import io.reactivex.flowable.internal.subscriptions.SubscriptionHelper;
import java.util.NoSuchElementException;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableLast<T>
extends AbstractFlowableWithUpstream<T, T> {
    final T defaultItem;
    final boolean errorOnEmpty;

    public FlowableLast(Flowable<T> source, T defaultItem, boolean errorOnEmpty) {
        super(source);
        this.defaultItem = defaultItem;
        this.errorOnEmpty = errorOnEmpty;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        this.source.subscribe(new LastSubscriber<T>(s, this.defaultItem, this.errorOnEmpty));
    }

    static final class LastSubscriber<T>
    extends DeferredScalarSubscription<T>
    implements RelaxedSubscriber<T> {
        private static final long serialVersionUID = 5455573518954847071L;
        final T defaultItem;
        final boolean errorOnEmpty;
        Subscription upstream;

        public LastSubscriber(Subscriber<? super T> actual, T defaultItem, boolean errorOnEmpty) {
            super(actual);
            this.defaultItem = defaultItem;
            this.errorOnEmpty = errorOnEmpty;
        }

        public void onNext(T t) {
            this.value = t;
        }

        public void onError(Throwable t) {
            this.value = null;
            this.actual.onError(t);
        }

        public void onComplete() {
            Object v = this.value;
            this.value = null;
            if (v == null) {
                if (this.errorOnEmpty) {
                    this.actual.onError((Throwable)new NoSuchElementException());
                } else {
                    this.actual.onComplete();
                }
            } else {
                this.complete(v);
            }
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.upstream, s)) {
                this.upstream = s;
                this.actual.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void cancel() {
            super.cancel();
            this.upstream.cancel();
        }
    }
}

