/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.flowable.internal.operators;

import hu.akarnokd.reactivestreams.extensions.ConditionalSubscriber;
import io.reactivex.common.annotations.Nullable;
import io.reactivex.common.functions.Function;
import io.reactivex.common.internal.functions.ObjectHelper;
import io.reactivex.flowable.Flowable;
import io.reactivex.flowable.internal.operators.AbstractFlowableWithUpstream;
import io.reactivex.flowable.internal.subscribers.BasicFuseableConditionalSubscriber;
import io.reactivex.flowable.internal.subscribers.BasicFuseableSubscriber;
import org.reactivestreams.Subscriber;

public final class FlowableMap<T, U>
extends AbstractFlowableWithUpstream<T, U> {
    final Function<? super T, ? extends U> mapper;

    public FlowableMap(Flowable<T> source, Function<? super T, ? extends U> mapper) {
        super(source);
        this.mapper = mapper;
    }

    @Override
    protected void subscribeActual(Subscriber<? super U> s) {
        if (s instanceof ConditionalSubscriber) {
            this.source.subscribe(new MapConditionalSubscriber<T, U>((ConditionalSubscriber)s, this.mapper));
        } else {
            this.source.subscribe(new MapSubscriber<T, U>(s, this.mapper));
        }
    }

    static final class MapConditionalSubscriber<T, U>
    extends BasicFuseableConditionalSubscriber<T, U> {
        final Function<? super T, ? extends U> mapper;

        MapConditionalSubscriber(ConditionalSubscriber<? super U> actual, Function<? super T, ? extends U> function) {
            super(actual);
            this.mapper = function;
        }

        public void onNext(T t) {
            Object v;
            if (this.done) {
                return;
            }
            if (this.sourceMode != 0) {
                this.actual.onNext(null);
                return;
            }
            try {
                v = ObjectHelper.requireNonNull((Object)this.mapper.apply(t), (String)"The mapper function returned a null value.");
            }
            catch (Throwable ex) {
                this.fail(ex);
                return;
            }
            this.actual.onNext(v);
        }

        public boolean tryOnNext(T t) {
            Object v;
            if (this.done) {
                return false;
            }
            try {
                v = ObjectHelper.requireNonNull((Object)this.mapper.apply(t), (String)"The mapper function returned a null value.");
            }
            catch (Throwable ex) {
                this.fail(ex);
                return true;
            }
            return this.actual.tryOnNext(v);
        }

        public int requestFusion(int mode) {
            return this.transitiveBoundaryFusion(mode);
        }

        @Nullable
        public U poll() throws Throwable {
            Object t = this.qs.poll();
            return (U)(t != null ? ObjectHelper.requireNonNull((Object)this.mapper.apply(t), (String)"The mapper function returned a null value.") : null);
        }
    }

    static final class MapSubscriber<T, U>
    extends BasicFuseableSubscriber<T, U> {
        final Function<? super T, ? extends U> mapper;

        MapSubscriber(Subscriber<? super U> actual, Function<? super T, ? extends U> mapper) {
            super(actual);
            this.mapper = mapper;
        }

        public void onNext(T t) {
            Object v;
            if (this.done) {
                return;
            }
            if (this.sourceMode != 0) {
                this.actual.onNext(null);
                return;
            }
            try {
                v = ObjectHelper.requireNonNull((Object)this.mapper.apply(t), (String)"The mapper function returned a null value.");
            }
            catch (Throwable ex) {
                this.fail(ex);
                return;
            }
            this.actual.onNext(v);
        }

        public int requestFusion(int mode) {
            return this.transitiveBoundaryFusion(mode);
        }

        @Nullable
        public U poll() throws Throwable {
            Object t = this.qs.poll();
            return (U)(t != null ? ObjectHelper.requireNonNull((Object)this.mapper.apply(t), (String)"The mapper function returned a null value.") : null);
        }
    }
}

