/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.flowable.internal.operators;

import io.reactivex.common.exceptions.Exceptions;
import io.reactivex.common.functions.Function;
import io.reactivex.common.internal.functions.ObjectHelper;
import io.reactivex.flowable.Flowable;
import io.reactivex.flowable.internal.operators.AbstractFlowableWithUpstream;
import io.reactivex.flowable.internal.subscribers.SinglePostCompleteSubscriber;
import java.util.concurrent.Callable;
import org.reactivestreams.Subscriber;

public final class FlowableMapNotification<T, R>
extends AbstractFlowableWithUpstream<T, R> {
    final Function<? super T, ? extends R> onNextMapper;
    final Function<? super Throwable, ? extends R> onErrorMapper;
    final Callable<? extends R> onCompleteSupplier;

    public FlowableMapNotification(Flowable<T> source, Function<? super T, ? extends R> onNextMapper, Function<? super Throwable, ? extends R> onErrorMapper, Callable<? extends R> onCompleteSupplier) {
        super(source);
        this.onNextMapper = onNextMapper;
        this.onErrorMapper = onErrorMapper;
        this.onCompleteSupplier = onCompleteSupplier;
    }

    @Override
    protected void subscribeActual(Subscriber<? super R> s) {
        this.source.subscribe(new MapNotificationSubscriber<T, R>(s, this.onNextMapper, this.onErrorMapper, this.onCompleteSupplier));
    }

    static final class MapNotificationSubscriber<T, R>
    extends SinglePostCompleteSubscriber<T, R> {
        private static final long serialVersionUID = 2757120512858778108L;
        final Function<? super T, ? extends R> onNextMapper;
        final Function<? super Throwable, ? extends R> onErrorMapper;
        final Callable<? extends R> onCompleteSupplier;

        MapNotificationSubscriber(Subscriber<? super R> actual, Function<? super T, ? extends R> onNextMapper, Function<? super Throwable, ? extends R> onErrorMapper, Callable<? extends R> onCompleteSupplier) {
            super(actual);
            this.onNextMapper = onNextMapper;
            this.onErrorMapper = onErrorMapper;
            this.onCompleteSupplier = onCompleteSupplier;
        }

        public void onNext(T t) {
            Object p;
            try {
                p = ObjectHelper.requireNonNull((Object)this.onNextMapper.apply(t), (String)"The onNext publisher returned is null");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal((Throwable)e);
                this.actual.onError(e);
                return;
            }
            ++this.produced;
            this.actual.onNext(p);
        }

        public void onError(Throwable t) {
            Object p;
            try {
                p = ObjectHelper.requireNonNull((Object)this.onErrorMapper.apply((Object)t), (String)"The onError publisher returned is null");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal((Throwable)e);
                this.actual.onError(e);
                return;
            }
            this.complete(p);
        }

        public void onComplete() {
            Object p;
            try {
                p = ObjectHelper.requireNonNull(this.onCompleteSupplier.call(), (String)"The onComplete publisher returned is null");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal((Throwable)e);
                this.actual.onError(e);
                return;
            }
            this.complete(p);
        }
    }
}

