/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.flowable.internal.operators;

import hu.akarnokd.reactivestreams.extensions.RelaxedSubscriber;
import io.reactivex.common.exceptions.Exceptions;
import io.reactivex.common.functions.Function;
import io.reactivex.common.internal.functions.ObjectHelper;
import io.reactivex.flowable.Flowable;
import io.reactivex.flowable.internal.operators.AbstractFlowableWithUpstream;
import io.reactivex.flowable.internal.subscriptions.EmptySubscription;
import io.reactivex.flowable.internal.subscriptions.SubscriptionArbiter;
import io.reactivex.flowable.internal.subscriptions.SubscriptionHelper;
import io.reactivex.flowable.processors.FlowableProcessor;
import io.reactivex.flowable.processors.UnicastProcessor;
import io.reactivex.flowable.subscribers.SerializedSubscriber;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableRepeatWhen<T>
extends AbstractFlowableWithUpstream<T, T> {
    final Function<? super Flowable<Object>, ? extends Publisher<?>> handler;

    public FlowableRepeatWhen(Flowable<T> source, Function<? super Flowable<Object>, ? extends Publisher<?>> handler) {
        super(source);
        this.handler = handler;
    }

    @Override
    public void subscribeActual(Subscriber<? super T> s) {
        Publisher when;
        SerializedSubscriber<? super T> z = new SerializedSubscriber<T>(s);
        FlowableProcessor<Object> processor = UnicastProcessor.create(8).toSerialized();
        try {
            when = (Publisher)ObjectHelper.requireNonNull((Object)this.handler.apply(processor), (String)"handler returned a null Publisher");
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal((Throwable)ex);
            EmptySubscription.error(ex, s);
            return;
        }
        WhenReceiver receiver = new WhenReceiver(this.source);
        RepeatWhenSubscriber subscriber = new RepeatWhenSubscriber(z, processor, (Subscription)receiver);
        receiver.subscriber = subscriber;
        s.onSubscribe(subscriber);
        when.subscribe(receiver);
        receiver.onNext(0);
    }

    static final class RepeatWhenSubscriber<T>
    extends WhenSourceSubscriber<T, Object> {
        private static final long serialVersionUID = -2680129890138081029L;

        RepeatWhenSubscriber(Subscriber<? super T> actual, FlowableProcessor<Object> processor, Subscription receiver) {
            super(actual, processor, receiver);
        }

        public void onError(Throwable t) {
            this.receiver.cancel();
            this.actual.onError(t);
        }

        public void onComplete() {
            this.again(0);
        }
    }

    static abstract class WhenSourceSubscriber<T, U>
    extends SubscriptionArbiter
    implements RelaxedSubscriber<T> {
        private static final long serialVersionUID = -5604623027276966720L;
        protected final Subscriber<? super T> actual;
        protected final FlowableProcessor<U> processor;
        protected final Subscription receiver;
        private long produced;

        WhenSourceSubscriber(Subscriber<? super T> actual, FlowableProcessor<U> processor, Subscription receiver) {
            this.actual = actual;
            this.processor = processor;
            this.receiver = receiver;
        }

        public final void onSubscribe(Subscription s) {
            this.setSubscription(s);
        }

        public final void onNext(T t) {
            ++this.produced;
            this.actual.onNext(t);
        }

        protected final void again(U signal) {
            long p = this.produced;
            if (p != 0L) {
                this.produced = 0L;
                this.produced(p);
            }
            this.receiver.request(1L);
            this.processor.onNext(signal);
        }

        @Override
        public final void cancel() {
            super.cancel();
            this.receiver.cancel();
        }
    }

    static final class WhenReceiver<T, U>
    extends AtomicInteger
    implements RelaxedSubscriber<Object>,
    Subscription {
        private static final long serialVersionUID = 2827772011130406689L;
        final Publisher<T> source;
        final AtomicReference<Subscription> subscription;
        final AtomicLong requested;
        WhenSourceSubscriber<T, U> subscriber;

        WhenReceiver(Publisher<T> source) {
            this.source = source;
            this.subscription = new AtomicReference();
            this.requested = new AtomicLong();
        }

        public void onSubscribe(Subscription s) {
            SubscriptionHelper.deferredSetOnce(this.subscription, this.requested, s);
        }

        public void onNext(Object t) {
            block2: {
                if (this.getAndIncrement() != 0) break block2;
                do {
                    if (SubscriptionHelper.isCancelled(this.subscription.get())) {
                        return;
                    }
                    this.source.subscribe(this.subscriber);
                } while (this.decrementAndGet() != 0);
            }
        }

        public void onError(Throwable t) {
            this.subscriber.cancel();
            this.subscriber.actual.onError(t);
        }

        public void onComplete() {
            this.subscriber.cancel();
            this.subscriber.actual.onComplete();
        }

        public void request(long n) {
            SubscriptionHelper.deferredRequest(this.subscription, this.requested, n);
        }

        public void cancel() {
            SubscriptionHelper.cancel(this.subscription);
        }
    }
}

