/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.flowable.internal.operators;

import hu.akarnokd.reactivestreams.extensions.RelaxedSubscriber;
import io.reactivex.common.RxJavaCommonPlugins;
import io.reactivex.common.exceptions.Exceptions;
import io.reactivex.common.functions.BiFunction;
import io.reactivex.common.internal.functions.ObjectHelper;
import io.reactivex.flowable.Flowable;
import io.reactivex.flowable.internal.operators.AbstractFlowableWithUpstream;
import io.reactivex.flowable.internal.queues.SimplePlainQueue;
import io.reactivex.flowable.internal.queues.SpscArrayQueue;
import io.reactivex.flowable.internal.subscriptions.EmptySubscription;
import io.reactivex.flowable.internal.subscriptions.SubscriptionHelper;
import io.reactivex.flowable.internal.utils.BackpressureHelper;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableScanSeed<T, R>
extends AbstractFlowableWithUpstream<T, R> {
    final BiFunction<R, ? super T, R> accumulator;
    final Callable<R> seedSupplier;

    public FlowableScanSeed(Flowable<T> source, Callable<R> seedSupplier, BiFunction<R, ? super T, R> accumulator) {
        super(source);
        this.accumulator = accumulator;
        this.seedSupplier = seedSupplier;
    }

    @Override
    protected void subscribeActual(Subscriber<? super R> s) {
        Object r;
        try {
            r = ObjectHelper.requireNonNull(this.seedSupplier.call(), (String)"The seed supplied is null");
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal((Throwable)e);
            EmptySubscription.error(e, s);
            return;
        }
        this.source.subscribe(new ScanSeedSubscriber<T, Object>(s, this.accumulator, r, FlowableScanSeed.bufferSize()));
    }

    static final class ScanSeedSubscriber<T, R>
    extends AtomicInteger
    implements RelaxedSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = -1776795561228106469L;
        final Subscriber<? super R> actual;
        final BiFunction<R, ? super T, R> accumulator;
        final SimplePlainQueue<R> queue;
        final AtomicLong requested;
        final int prefetch;
        final int limit;
        volatile boolean cancelled;
        volatile boolean done;
        Throwable error;
        Subscription s;
        R value;
        int consumed;

        ScanSeedSubscriber(Subscriber<? super R> actual, BiFunction<R, ? super T, R> accumulator, R value, int prefetch) {
            this.actual = actual;
            this.accumulator = accumulator;
            this.value = value;
            this.prefetch = prefetch;
            this.limit = prefetch - (prefetch >> 2);
            this.queue = new SpscArrayQueue<R>(prefetch);
            this.queue.offer(value);
            this.requested = new AtomicLong();
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                s.request((long)(this.prefetch - 1));
            }
        }

        public void onNext(T t) {
            if (this.done) {
                return;
            }
            Object v = this.value;
            try {
                v = ObjectHelper.requireNonNull((Object)this.accumulator.apply(v, t), (String)"The accumulator returned a null value");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.s.cancel();
                this.onError(ex);
                return;
            }
            this.value = v;
            this.queue.offer(v);
            this.drain();
        }

        public void onError(Throwable t) {
            if (this.done) {
                RxJavaCommonPlugins.onError((Throwable)t);
                return;
            }
            this.error = t;
            this.done = true;
            this.drain();
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.drain();
        }

        public void cancel() {
            this.cancelled = true;
            this.s.cancel();
            if (this.getAndIncrement() == 0) {
                this.queue.clear();
            }
        }

        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.add(this.requested, n);
                this.drain();
            }
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Subscriber<? super R> a = this.actual;
            SimplePlainQueue<R> q = this.queue;
            int lim = this.limit;
            int c = this.consumed;
            do {
                long e;
                long r = this.requested.get();
                for (e = 0L; e != r; ++e) {
                    boolean empty;
                    Throwable ex;
                    if (this.cancelled) {
                        q.clear();
                        return;
                    }
                    boolean d = this.done;
                    if (d && (ex = this.error) != null) {
                        q.clear();
                        a.onError(ex);
                        return;
                    }
                    R v = q.poll();
                    boolean bl = empty = v == null;
                    if (d && empty) {
                        a.onComplete();
                        return;
                    }
                    if (empty) break;
                    a.onNext(v);
                    if (++c != lim) continue;
                    c = 0;
                    this.s.request((long)lim);
                }
                if (e == r && this.done) {
                    Throwable ex = this.error;
                    if (ex != null) {
                        q.clear();
                        a.onError(ex);
                        return;
                    }
                    if (q.isEmpty()) {
                        a.onComplete();
                        return;
                    }
                }
                if (e != 0L) {
                    BackpressureHelper.produced(this.requested, e);
                }
                this.consumed = c;
            } while ((missed = this.addAndGet(-missed)) != 0);
        }
    }
}

