/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.flowable.internal.operators;

import hu.akarnokd.reactivestreams.extensions.ConditionalSubscriber;
import hu.akarnokd.reactivestreams.extensions.RelaxedSubscriber;
import io.reactivex.common.internal.utils.AtomicThrowable;
import io.reactivex.flowable.Flowable;
import io.reactivex.flowable.internal.operators.AbstractFlowableWithUpstream;
import io.reactivex.flowable.internal.subscriptions.SubscriptionHelper;
import io.reactivex.flowable.internal.utils.HalfSerializer;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableSkipUntil<T, U>
extends AbstractFlowableWithUpstream<T, T> {
    final Publisher<U> other;

    public FlowableSkipUntil(Flowable<T> source, Publisher<U> other) {
        super(source);
        this.other = other;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> child) {
        SkipUntilMainSubscriber<? super T> parent = new SkipUntilMainSubscriber<T>(child);
        child.onSubscribe(parent);
        this.other.subscribe((Subscriber)parent.other);
        this.source.subscribe(parent);
    }

    static final class SkipUntilMainSubscriber<T>
    extends AtomicInteger
    implements ConditionalSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = -6270983465606289181L;
        final Subscriber<? super T> actual;
        final AtomicReference<Subscription> s;
        final AtomicLong requested;
        final OtherSubscriber other;
        final AtomicThrowable error;
        volatile boolean gate;

        SkipUntilMainSubscriber(Subscriber<? super T> actual) {
            this.actual = actual;
            this.s = new AtomicReference();
            this.requested = new AtomicLong();
            this.other = new OtherSubscriber();
            this.error = new AtomicThrowable();
        }

        public void onSubscribe(Subscription s) {
            SubscriptionHelper.deferredSetOnce(this.s, this.requested, s);
        }

        public void onNext(T t) {
            if (!this.tryOnNext(t)) {
                this.s.get().request(1L);
            }
        }

        public boolean tryOnNext(T t) {
            if (this.gate) {
                HalfSerializer.onNext(this.actual, t, this, this.error);
                return true;
            }
            return false;
        }

        public void onError(Throwable t) {
            SubscriptionHelper.cancel(this.other);
            HalfSerializer.onError(this.actual, t, this, this.error);
        }

        public void onComplete() {
            SubscriptionHelper.cancel(this.other);
            HalfSerializer.onComplete(this.actual, this, this.error);
        }

        public void request(long n) {
            SubscriptionHelper.deferredRequest(this.s, this.requested, n);
        }

        public void cancel() {
            SubscriptionHelper.cancel(this.s);
            SubscriptionHelper.cancel(this.other);
        }

        final class OtherSubscriber
        extends AtomicReference<Subscription>
        implements RelaxedSubscriber<Object> {
            private static final long serialVersionUID = -5592042965931999169L;

            OtherSubscriber() {
            }

            public void onSubscribe(Subscription s) {
                if (SubscriptionHelper.setOnce(this, s)) {
                    s.request(Long.MAX_VALUE);
                }
            }

            public void onNext(Object t) {
                SkipUntilMainSubscriber.this.gate = true;
                ((Subscription)this.get()).cancel();
            }

            public void onError(Throwable t) {
                SubscriptionHelper.cancel(SkipUntilMainSubscriber.this.s);
                HalfSerializer.onError(SkipUntilMainSubscriber.this.actual, t, SkipUntilMainSubscriber.this, SkipUntilMainSubscriber.this.error);
            }

            public void onComplete() {
                SkipUntilMainSubscriber.this.gate = true;
            }
        }
    }
}

