/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.flowable.internal.operators;

import io.reactivex.common.Disposable;
import io.reactivex.common.Scheduler;
import io.reactivex.common.exceptions.MissingBackpressureException;
import io.reactivex.common.internal.disposables.DisposableHelper;
import io.reactivex.common.internal.disposables.DisposedDisposable;
import io.reactivex.flowable.Flowable;
import io.reactivex.flowable.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableTimer
extends Flowable<Long> {
    final Scheduler scheduler;
    final long delay;
    final TimeUnit unit;

    public FlowableTimer(long delay, TimeUnit unit, Scheduler scheduler) {
        this.delay = delay;
        this.unit = unit;
        this.scheduler = scheduler;
    }

    @Override
    public void subscribeActual(Subscriber<? super Long> s) {
        TimerSubscriber ios = new TimerSubscriber(s);
        s.onSubscribe((Subscription)ios);
        Disposable d = this.scheduler.scheduleDirect((Runnable)ios, this.delay, this.unit);
        ios.setResource(d);
    }

    static final class TimerSubscriber
    extends AtomicReference<Disposable>
    implements Subscription,
    Runnable {
        private static final long serialVersionUID = -2809475196591179431L;
        final Subscriber<? super Long> actual;
        volatile boolean requested;

        TimerSubscriber(Subscriber<? super Long> actual) {
            this.actual = actual;
        }

        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                this.requested = true;
            }
        }

        public void cancel() {
            DisposableHelper.dispose((AtomicReference)this);
        }

        @Override
        public void run() {
            if (this.get() != DisposableHelper.DISPOSED) {
                if (this.requested) {
                    this.actual.onNext((Object)0L);
                    this.lazySet(DisposedDisposable.INSTANCE);
                    this.actual.onComplete();
                } else {
                    this.lazySet(DisposedDisposable.INSTANCE);
                    this.actual.onError((Throwable)new MissingBackpressureException("Can't deliver value due to lack of requests"));
                }
            }
        }

        public void setResource(Disposable d) {
            DisposableHelper.trySet((AtomicReference)this, (Disposable)d);
        }
    }
}

