/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.flowable.internal.operators;

import hu.akarnokd.reactivestreams.extensions.RelaxedSubscriber;
import io.reactivex.common.RxJavaCommonPlugins;
import io.reactivex.common.exceptions.Exceptions;
import io.reactivex.common.functions.BiFunction;
import io.reactivex.common.internal.functions.ObjectHelper;
import io.reactivex.flowable.Flowable;
import io.reactivex.flowable.internal.operators.AbstractFlowableWithUpstream;
import io.reactivex.flowable.internal.subscriptions.EmptySubscription;
import io.reactivex.flowable.internal.subscriptions.SubscriptionHelper;
import java.util.Iterator;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableZipIterable<T, U, V>
extends AbstractFlowableWithUpstream<T, V> {
    final Iterable<U> other;
    final BiFunction<? super T, ? super U, ? extends V> zipper;

    public FlowableZipIterable(Flowable<T> source, Iterable<U> other, BiFunction<? super T, ? super U, ? extends V> zipper) {
        super(source);
        this.other = other;
        this.zipper = zipper;
    }

    @Override
    public void subscribeActual(Subscriber<? super V> t) {
        boolean b;
        Iterator it;
        try {
            it = (Iterator)ObjectHelper.requireNonNull(this.other.iterator(), (String)"The iterator returned by other is null");
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal((Throwable)e);
            EmptySubscription.error(e, t);
            return;
        }
        try {
            b = it.hasNext();
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal((Throwable)e);
            EmptySubscription.error(e, t);
            return;
        }
        if (!b) {
            EmptySubscription.complete(t);
            return;
        }
        this.source.subscribe(new ZipIterableSubscriber<T, U, V>(t, it, this.zipper));
    }

    static final class ZipIterableSubscriber<T, U, V>
    implements RelaxedSubscriber<T>,
    Subscription {
        final Subscriber<? super V> actual;
        final Iterator<U> iterator;
        final BiFunction<? super T, ? super U, ? extends V> zipper;
        Subscription s;
        boolean done;

        ZipIterableSubscriber(Subscriber<? super V> actual, Iterator<U> iterator, BiFunction<? super T, ? super U, ? extends V> zipper) {
            this.actual = actual;
            this.iterator = iterator;
            this.zipper = zipper;
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            boolean b;
            Object v;
            Object u;
            if (this.done) {
                return;
            }
            try {
                u = ObjectHelper.requireNonNull(this.iterator.next(), (String)"The iterator returned a null value");
            }
            catch (Throwable e) {
                this.error(e);
                return;
            }
            try {
                v = ObjectHelper.requireNonNull((Object)this.zipper.apply(t, u), (String)"The zipper function returned a null value");
            }
            catch (Throwable e) {
                this.error(e);
                return;
            }
            this.actual.onNext(v);
            try {
                b = this.iterator.hasNext();
            }
            catch (Throwable e) {
                this.error(e);
                return;
            }
            if (!b) {
                this.done = true;
                this.s.cancel();
                this.actual.onComplete();
            }
        }

        void error(Throwable e) {
            Exceptions.throwIfFatal((Throwable)e);
            this.done = true;
            this.s.cancel();
            this.actual.onError(e);
        }

        public void onError(Throwable t) {
            if (this.done) {
                RxJavaCommonPlugins.onError((Throwable)t);
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.actual.onComplete();
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            this.s.cancel();
        }
    }
}

