/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.flowable.internal.operators;

import hu.akarnokd.reactivestreams.extensions.ConditionalSubscriber;
import io.reactivex.common.RxJavaCommonPlugins;
import io.reactivex.common.exceptions.CompositeException;
import io.reactivex.common.exceptions.Exceptions;
import io.reactivex.common.functions.BiFunction;
import io.reactivex.common.functions.Predicate;
import io.reactivex.common.internal.functions.ObjectHelper;
import io.reactivex.flowable.ParallelFailureHandling;
import io.reactivex.flowable.ParallelFlowable;
import io.reactivex.flowable.internal.subscriptions.SubscriptionHelper;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class ParallelFilterTry<T>
extends ParallelFlowable<T> {
    final ParallelFlowable<T> source;
    final Predicate<? super T> predicate;
    final BiFunction<? super Long, ? super Throwable, ParallelFailureHandling> errorHandler;

    public ParallelFilterTry(ParallelFlowable<T> source, Predicate<? super T> predicate, BiFunction<? super Long, ? super Throwable, ParallelFailureHandling> errorHandler) {
        this.source = source;
        this.predicate = predicate;
        this.errorHandler = errorHandler;
    }

    @Override
    public void subscribe(Subscriber<? super T>[] subscribers) {
        if (!this.validate(subscribers)) {
            return;
        }
        int n = subscribers.length;
        Subscriber[] parents = new Subscriber[n];
        for (int i = 0; i < n; ++i) {
            Subscriber<? super T> a = subscribers[i];
            parents[i] = a instanceof ConditionalSubscriber ? new ParallelFilterConditionalSubscriber<T>((ConditionalSubscriber)a, this.predicate, this.errorHandler) : new ParallelFilterSubscriber<T>(a, this.predicate, this.errorHandler);
        }
        this.source.subscribe(parents);
    }

    @Override
    public int parallelism() {
        return this.source.parallelism();
    }

    static final class ParallelFilterConditionalSubscriber<T>
    extends BaseFilterSubscriber<T> {
        final ConditionalSubscriber<? super T> actual;

        ParallelFilterConditionalSubscriber(ConditionalSubscriber<? super T> actual, Predicate<? super T> predicate, BiFunction<? super Long, ? super Throwable, ParallelFailureHandling> errorHandler) {
            super(predicate, errorHandler);
            this.actual = actual;
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public boolean tryOnNext(T t) {
            if (!this.done) {
                boolean b;
                long retries = 0L;
                block9: while (true) {
                    try {
                        b = this.predicate.test(t);
                    }
                    catch (Throwable ex) {
                        ParallelFailureHandling h;
                        Exceptions.throwIfFatal((Throwable)ex);
                        try {
                            h = (ParallelFailureHandling)((Object)ObjectHelper.requireNonNull((Object)this.errorHandler.apply((Object)(++retries), (Object)ex), (String)"The errorHandler returned a null item"));
                        }
                        catch (Throwable exc) {
                            Exceptions.throwIfFatal((Throwable)exc);
                            this.cancel();
                            this.onError((Throwable)new CompositeException(new Throwable[]{ex, exc}));
                            return false;
                        }
                        switch (h) {
                            case RETRY: {
                                continue block9;
                            }
                            case SKIP: {
                                return false;
                            }
                            case STOP: {
                                this.cancel();
                                this.onComplete();
                                return false;
                            }
                        }
                        this.cancel();
                        this.onError(ex);
                        return false;
                    }
                    break;
                }
                return b && this.actual.tryOnNext(t);
            }
            return false;
        }

        public void onError(Throwable t) {
            if (this.done) {
                RxJavaCommonPlugins.onError((Throwable)t);
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        public void onComplete() {
            if (!this.done) {
                this.done = true;
                this.actual.onComplete();
            }
        }
    }

    static final class ParallelFilterSubscriber<T>
    extends BaseFilterSubscriber<T> {
        final Subscriber<? super T> actual;

        ParallelFilterSubscriber(Subscriber<? super T> actual, Predicate<? super T> predicate, BiFunction<? super Long, ? super Throwable, ParallelFailureHandling> errorHandler) {
            super(predicate, errorHandler);
            this.actual = actual;
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public boolean tryOnNext(T t) {
            if (!this.done) {
                boolean b;
                long retries = 0L;
                block9: while (true) {
                    try {
                        b = this.predicate.test(t);
                    }
                    catch (Throwable ex) {
                        ParallelFailureHandling h;
                        Exceptions.throwIfFatal((Throwable)ex);
                        try {
                            h = (ParallelFailureHandling)((Object)ObjectHelper.requireNonNull((Object)this.errorHandler.apply((Object)(++retries), (Object)ex), (String)"The errorHandler returned a null item"));
                        }
                        catch (Throwable exc) {
                            Exceptions.throwIfFatal((Throwable)exc);
                            this.cancel();
                            this.onError((Throwable)new CompositeException(new Throwable[]{ex, exc}));
                            return false;
                        }
                        switch (h) {
                            case RETRY: {
                                continue block9;
                            }
                            case SKIP: {
                                return false;
                            }
                            case STOP: {
                                this.cancel();
                                this.onComplete();
                                return false;
                            }
                        }
                        this.cancel();
                        this.onError(ex);
                        return false;
                    }
                    break;
                }
                if (b) {
                    this.actual.onNext(t);
                    return true;
                }
                return false;
            }
            return false;
        }

        public void onError(Throwable t) {
            if (this.done) {
                RxJavaCommonPlugins.onError((Throwable)t);
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        public void onComplete() {
            if (!this.done) {
                this.done = true;
                this.actual.onComplete();
            }
        }
    }

    static abstract class BaseFilterSubscriber<T>
    implements ConditionalSubscriber<T>,
    Subscription {
        final Predicate<? super T> predicate;
        final BiFunction<? super Long, ? super Throwable, ParallelFailureHandling> errorHandler;
        Subscription s;
        boolean done;

        BaseFilterSubscriber(Predicate<? super T> predicate, BiFunction<? super Long, ? super Throwable, ParallelFailureHandling> errorHandler) {
            this.predicate = predicate;
            this.errorHandler = errorHandler;
        }

        public final void request(long n) {
            this.s.request(n);
        }

        public final void cancel() {
            this.s.cancel();
        }

        public final void onNext(T t) {
            if (!this.tryOnNext(t) && !this.done) {
                this.s.request(1L);
            }
        }
    }
}

