/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.flowable.internal.subscribers;

import hu.akarnokd.reactivestreams.extensions.FusedQueueSubscription;
import hu.akarnokd.reactivestreams.extensions.RelaxedSubscriber;
import io.reactivex.common.RxJavaCommonPlugins;
import io.reactivex.common.exceptions.Exceptions;
import io.reactivex.flowable.internal.subscriptions.SubscriptionHelper;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public abstract class BasicFuseableSubscriber<T, R>
implements RelaxedSubscriber<T>,
FusedQueueSubscription<R> {
    protected final Subscriber<? super R> actual;
    protected Subscription s;
    protected FusedQueueSubscription<T> qs;
    protected boolean done;
    protected int sourceMode;

    public BasicFuseableSubscriber(Subscriber<? super R> actual) {
        this.actual = actual;
    }

    public final void onSubscribe(Subscription s) {
        if (SubscriptionHelper.validate(this.s, s)) {
            this.s = s;
            if (s instanceof FusedQueueSubscription) {
                this.qs = (FusedQueueSubscription)s;
            }
            if (this.beforeDownstream()) {
                this.actual.onSubscribe((Subscription)this);
                this.afterDownstream();
            }
        }
    }

    protected boolean beforeDownstream() {
        return true;
    }

    protected void afterDownstream() {
    }

    public void onError(Throwable t) {
        if (this.done) {
            RxJavaCommonPlugins.onError((Throwable)t);
            return;
        }
        this.done = true;
        this.actual.onError(t);
    }

    protected final void fail(Throwable t) {
        Exceptions.throwIfFatal((Throwable)t);
        this.s.cancel();
        this.onError(t);
    }

    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        this.actual.onComplete();
    }

    protected final int transitiveBoundaryFusion(int mode) {
        FusedQueueSubscription<T> qs = this.qs;
        if (qs != null && (mode & 4) == 0) {
            int m = qs.requestFusion(mode);
            if (m != 0) {
                this.sourceMode = m;
            }
            return m;
        }
        return 0;
    }

    public void request(long n) {
        this.s.request(n);
    }

    public void cancel() {
        this.s.cancel();
    }

    public boolean isEmpty() {
        return this.qs.isEmpty();
    }

    public void clear() {
        this.qs.clear();
    }

    public final boolean offer(R e) {
        throw new UnsupportedOperationException("Should not be called!");
    }
}

