/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.flowable.internal.subscribers;

import hu.akarnokd.reactivestreams.extensions.RelaxedSubscriber;
import io.reactivex.flowable.internal.subscriptions.DeferredScalarSubscription;
import io.reactivex.flowable.internal.subscriptions.SubscriptionHelper;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public abstract class DeferredScalarSubscriber<T, R>
extends DeferredScalarSubscription<R>
implements RelaxedSubscriber<T> {
    private static final long serialVersionUID = 2984505488220891551L;
    protected Subscription s;
    protected boolean hasValue;

    public DeferredScalarSubscriber(Subscriber<? super R> actual) {
        super(actual);
    }

    public void onSubscribe(Subscription s) {
        if (SubscriptionHelper.validate(this.s, s)) {
            this.s = s;
            this.actual.onSubscribe((Subscription)this);
            s.request(Long.MAX_VALUE);
        }
    }

    public void onError(Throwable t) {
        this.value = null;
        this.actual.onError(t);
    }

    public void onComplete() {
        if (this.hasValue) {
            this.complete(this.value);
        } else {
            this.actual.onComplete();
        }
    }

    @Override
    public void cancel() {
        super.cancel();
        this.s.cancel();
    }
}

