/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.flowable.internal.subscribers;

import hu.akarnokd.reactivestreams.extensions.RelaxedSubscriber;
import io.reactivex.common.Disposable;
import io.reactivex.common.RxJavaCommonPlugins;
import io.reactivex.common.exceptions.CompositeException;
import io.reactivex.common.exceptions.Exceptions;
import io.reactivex.common.functions.Action;
import io.reactivex.common.functions.Consumer;
import io.reactivex.flowable.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscription;

public final class LambdaSubscriber<T>
extends AtomicReference<Subscription>
implements RelaxedSubscriber<T>,
Subscription,
Disposable {
    private static final long serialVersionUID = -7251123623727029452L;
    final Consumer<? super T> onNext;
    final Consumer<? super Throwable> onError;
    final Action onComplete;
    final Consumer<? super Subscription> onSubscribe;

    public LambdaSubscriber(Consumer<? super T> onNext, Consumer<? super Throwable> onError, Action onComplete, Consumer<? super Subscription> onSubscribe) {
        this.onNext = onNext;
        this.onError = onError;
        this.onComplete = onComplete;
        this.onSubscribe = onSubscribe;
    }

    public void onSubscribe(Subscription s) {
        if (SubscriptionHelper.setOnce(this, s)) {
            try {
                this.onSubscribe.accept((Object)this);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                s.cancel();
                this.onError(ex);
            }
        }
    }

    public void onNext(T t) {
        if (!this.isDisposed()) {
            try {
                this.onNext.accept(t);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal((Throwable)e);
                ((Subscription)this.get()).cancel();
                this.onError(e);
            }
        }
    }

    public void onError(Throwable t) {
        if (this.get() != SubscriptionHelper.CANCELLED) {
            this.lazySet(SubscriptionHelper.CANCELLED);
            try {
                this.onError.accept((Object)t);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal((Throwable)e);
                RxJavaCommonPlugins.onError((Throwable)new CompositeException(new Throwable[]{t, e}));
            }
        } else {
            RxJavaCommonPlugins.onError((Throwable)t);
        }
    }

    public void onComplete() {
        if (this.get() != SubscriptionHelper.CANCELLED) {
            this.lazySet(SubscriptionHelper.CANCELLED);
            try {
                this.onComplete.run();
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal((Throwable)e);
                RxJavaCommonPlugins.onError((Throwable)e);
            }
        }
    }

    public void dispose() {
        this.cancel();
    }

    public boolean isDisposed() {
        return this.get() == SubscriptionHelper.CANCELLED;
    }

    public void request(long n) {
        ((Subscription)this.get()).request(n);
    }

    public void cancel() {
        SubscriptionHelper.cancel(this);
    }
}

