/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.flowable.subscribers;

import hu.akarnokd.reactivestreams.extensions.RelaxedSubscriber;
import io.reactivex.common.RxJavaCommonPlugins;
import io.reactivex.common.exceptions.CompositeException;
import io.reactivex.common.exceptions.Exceptions;
import io.reactivex.flowable.internal.subscriptions.EmptySubscription;
import io.reactivex.flowable.internal.subscriptions.SubscriptionHelper;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class SafeSubscriber<T>
implements RelaxedSubscriber<T>,
Subscription {
    final Subscriber<? super T> actual;
    Subscription s;
    boolean done;

    public SafeSubscriber(Subscriber<? super T> actual) {
        this.actual = actual;
    }

    public void onSubscribe(Subscription s) {
        if (SubscriptionHelper.validate(this.s, s)) {
            this.s = s;
            try {
                this.actual.onSubscribe((Subscription)this);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal((Throwable)e);
                this.done = true;
                try {
                    s.cancel();
                }
                catch (Throwable e1) {
                    Exceptions.throwIfFatal((Throwable)e1);
                    RxJavaCommonPlugins.onError((Throwable)new CompositeException(new Throwable[]{e, e1}));
                    return;
                }
                RxJavaCommonPlugins.onError((Throwable)e);
            }
        }
    }

    public void onNext(T t) {
        if (this.done) {
            return;
        }
        if (this.s == null) {
            this.onNextNoSubscription();
            return;
        }
        if (t == null) {
            NullPointerException ex = new NullPointerException("onNext called with null. Null values are generally not allowed in 2.x operators and sources.");
            try {
                this.s.cancel();
            }
            catch (Throwable e1) {
                Exceptions.throwIfFatal((Throwable)e1);
                this.onError((Throwable)new CompositeException(new Throwable[]{ex, e1}));
                return;
            }
            this.onError(ex);
            return;
        }
        try {
            this.actual.onNext(t);
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal((Throwable)e);
            try {
                this.s.cancel();
            }
            catch (Throwable e1) {
                Exceptions.throwIfFatal((Throwable)e1);
                this.onError((Throwable)new CompositeException(new Throwable[]{e, e1}));
                return;
            }
            this.onError(e);
        }
    }

    void onNextNoSubscription() {
        this.done = true;
        NullPointerException ex = new NullPointerException("Subscription not set!");
        try {
            this.actual.onSubscribe((Subscription)EmptySubscription.INSTANCE);
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal((Throwable)e);
            RxJavaCommonPlugins.onError((Throwable)new CompositeException(new Throwable[]{ex, e}));
            return;
        }
        try {
            this.actual.onError((Throwable)ex);
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal((Throwable)e);
            RxJavaCommonPlugins.onError((Throwable)new CompositeException(new Throwable[]{ex, e}));
        }
    }

    public void onError(Throwable t) {
        if (this.done) {
            RxJavaCommonPlugins.onError((Throwable)t);
            return;
        }
        this.done = true;
        if (this.s == null) {
            NullPointerException npe = new NullPointerException("Subscription not set!");
            try {
                this.actual.onSubscribe((Subscription)EmptySubscription.INSTANCE);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal((Throwable)e);
                RxJavaCommonPlugins.onError((Throwable)new CompositeException(new Throwable[]{t, npe, e}));
                return;
            }
            try {
                this.actual.onError((Throwable)new CompositeException(new Throwable[]{t, npe}));
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal((Throwable)e);
                RxJavaCommonPlugins.onError((Throwable)new CompositeException(new Throwable[]{t, npe, e}));
            }
            return;
        }
        if (t == null) {
            t = new NullPointerException("onError called with null. Null values are generally not allowed in 2.x operators and sources.");
        }
        try {
            this.actual.onError(t);
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal((Throwable)ex);
            RxJavaCommonPlugins.onError((Throwable)new CompositeException(new Throwable[]{t, ex}));
        }
    }

    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        if (this.s == null) {
            this.onCompleteNoSubscription();
            return;
        }
        try {
            this.actual.onComplete();
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal((Throwable)e);
            RxJavaCommonPlugins.onError((Throwable)e);
        }
    }

    void onCompleteNoSubscription() {
        NullPointerException ex = new NullPointerException("Subscription not set!");
        try {
            this.actual.onSubscribe((Subscription)EmptySubscription.INSTANCE);
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal((Throwable)e);
            RxJavaCommonPlugins.onError((Throwable)new CompositeException(new Throwable[]{ex, e}));
            return;
        }
        try {
            this.actual.onError((Throwable)ex);
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal((Throwable)e);
            RxJavaCommonPlugins.onError((Throwable)new CompositeException(new Throwable[]{ex, e}));
        }
    }

    public void request(long n) {
        try {
            this.s.request(n);
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal((Throwable)e);
            try {
                this.s.cancel();
            }
            catch (Throwable e1) {
                Exceptions.throwIfFatal((Throwable)e1);
                RxJavaCommonPlugins.onError((Throwable)new CompositeException(new Throwable[]{e, e1}));
                return;
            }
            RxJavaCommonPlugins.onError((Throwable)e);
        }
    }

    public void cancel() {
        try {
            this.s.cancel();
        }
        catch (Throwable e1) {
            Exceptions.throwIfFatal((Throwable)e1);
            RxJavaCommonPlugins.onError((Throwable)e1);
        }
    }
}

