/*
 * Decompiled with CFR 0.152.
 */
package com.eblly;

import java.util.Date;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DateKit {
    private static final DateTimeFormatter yyyy = DateTimeFormat.forPattern((String)"yyyy");
    private static final DateTimeFormatter ym = DateTimeFormat.forPattern((String)"yyyy-MM");
    private static final DateTimeFormatter ymd = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
    private static final DateTimeFormatter ymdh = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH");
    private static final DateTimeFormatter ymdhm = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm");
    private static final DateTimeFormatter ymdhms = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
    private static final DateTimeFormatter md = DateTimeFormat.forPattern((String)"MM-dd");
    private static final DateTimeFormatter dd = DateTimeFormat.forPattern((String)"dd");
    private static final DateTimeFormatter hh = DateTimeFormat.forPattern((String)"HH");
    private static final DateTimeFormatter hm = DateTimeFormat.forPattern((String)"HH:mm");
    private static final DateTimeFormatter hm2 = DateTimeFormat.forPattern((String)"HHmm");
    private static final DateTimeFormatter hms = DateTimeFormat.forPattern((String)"HH:mm:ss");
    private static final DateTimeFormatter ym2 = DateTimeFormat.forPattern((String)"yyyyMM");
    private static final DateTimeFormatter ymd2 = DateTimeFormat.forPattern((String)"yyyyMMdd");
    private static final DateTimeFormatter ymdhms2 = DateTimeFormat.forPattern((String)"yyyyMMddHHmmss");
    private static final DateTimeFormatter ymdhmss = DateTimeFormat.forPattern((String)"yyyyMMddHHmmssSSS");

    public static String yFormat(Date date) {
        return new DateTime((Object)date).toString("yyyy");
    }

    public static String yMFormat(Date date) {
        return new DateTime((Object)date).toString("yyyy-MM");
    }

    public static String yMdFormat(Date date) {
        return new DateTime((Object)date).toString("yyyy-MM-dd");
    }

    public static String ymdhFormat(Date date) {
        return new DateTime((Object)date).toString("yyyy-MM-dd HH");
    }

    public static String ymdhmFormat(Date date) {
        return new DateTime((Object)date).toString("yyyy-MM-dd HH:mm");
    }

    public static String ymdhmsFormat(Date date) {
        return new DateTime((Object)date).toString("yyyy-MM-dd HH:mm:ss");
    }

    public static String mdFormat(Date date) {
        return new DateTime((Object)date).toString("MM-dd");
    }

    public static String dFormat(Date date) {
        return new DateTime((Object)date).toString("dd");
    }

    public static String hFormat(Date date) {
        return new DateTime((Object)date).toString("HH");
    }

    public static String hmFormat(Date date) {
        return new DateTime((Object)date).toString("HH:mm");
    }

    public static String hm2Format(Date date) {
        return new DateTime((Object)date).toString("HHmm");
    }

    public static String hmsFormat(Date date) {
        return new DateTime((Object)date).toString("HH:mm:ss");
    }

    public static String hms2Format(Date date) {
        return new DateTime((Object)date).toString("HHmmss");
    }

    public static String ymFormat(Date date) {
        return new DateTime((Object)date).toString("yyyyMM");
    }

    public static String ymd2Format(Date date) {
        return new DateTime((Object)date).toString("yyyyMMdd");
    }

    public static String ymdhms2Format(Date date) {
        return new DateTime((Object)date).toString("yyyyMMddHHmmss");
    }

    public static String ymdhmssFormat(Date date) {
        return new DateTime((Object)date).toString("yyyyMMddHHmmssSSS");
    }

    public static Date yyyyParse(String dateStr) {
        return DateTime.parse((String)dateStr, (DateTimeFormatter)yyyy).toDate();
    }

    public static Date ymParse(String dateStr) {
        return DateTime.parse((String)dateStr, (DateTimeFormatter)ym).toDate();
    }

    public static Date ymdParse(String dateStr) {
        return DateTime.parse((String)dateStr, (DateTimeFormatter)ymd).toDate();
    }

    public static Date ymdhParse(String dateStr) {
        return DateTime.parse((String)dateStr, (DateTimeFormatter)ymdh).toDate();
    }

    public static Date ymdhmParse(String dateStr) {
        return DateTime.parse((String)dateStr, (DateTimeFormatter)ymdhm).toDate();
    }

    public static Date ymdhmsParse(String dateStr) {
        return DateTime.parse((String)dateStr, (DateTimeFormatter)ymdhms).toDate();
    }

    public static Date mdParse(String dateStr) {
        return DateTime.parse((String)dateStr, (DateTimeFormatter)md).toDate();
    }

    public static Date ddParse(String dateStr) {
        return DateTime.parse((String)dateStr, (DateTimeFormatter)dd).toDate();
    }

    public static Date hhParse(String dateStr) {
        return DateTime.parse((String)dateStr, (DateTimeFormatter)hh).toDate();
    }

    public static Date hmParse(String dateStr) {
        return DateTime.parse((String)dateStr, (DateTimeFormatter)hm).toDate();
    }

    public static Date hm2Parse(String dateStr) {
        return DateTime.parse((String)dateStr, (DateTimeFormatter)hm2).toDate();
    }

    public static Date hmsParse(String dateStr) {
        return DateTime.parse((String)dateStr, (DateTimeFormatter)hms).toDate();
    }

    public static Date ym2Parse(String dateStr) {
        return DateTime.parse((String)dateStr, (DateTimeFormatter)ym2).toDate();
    }

    public static Date ymd2Parse(String dateStr) {
        return DateTime.parse((String)dateStr, (DateTimeFormatter)ymd2).toDate();
    }

    public static Date ymdhms2Parse(String dateStr) {
        return DateTime.parse((String)dateStr, (DateTimeFormatter)ymdhms2).toDate();
    }

    public static Date ymdhmssParse(String dateStr) {
        return DateTime.parse((String)dateStr, (DateTimeFormatter)ymdhmss).toDate();
    }

    public static Date withDayOfWeek(Object date, int dayOfWeek) {
        DateTime dt = new DateTime(date);
        return dt.withDayOfWeek(dayOfWeek).toDate();
    }

    public static int intervalDay(Date date1, Date date2) {
        DateTime dt1 = new DateTime((Object)date1);
        DateTime dt2 = new DateTime((Object)date2);
        int compare = dt1.compareTo((ReadableInstant)dt2);
        if (compare <= 0) {
            return Days.daysBetween((ReadablePartial)dt1.toLocalDate(), (ReadablePartial)dt2.toLocalDate()).getDays();
        }
        return Days.daysBetween((ReadablePartial)dt2.toLocalDate(), (ReadablePartial)dt1.toLocalDate()).getDays();
    }

    public static int intervalDayTime(Date date1, Date date2) {
        DateTime dt1 = new DateTime((Object)date1);
        DateTime dt2 = new DateTime((Object)date2);
        int compare = dt1.compareTo((ReadableInstant)dt2);
        if (compare <= 0) {
            return Days.daysBetween((ReadablePartial)dt1.toLocalDateTime(), (ReadablePartial)dt2.toLocalDateTime()).getDays();
        }
        return Days.daysBetween((ReadablePartial)dt2.toLocalDateTime(), (ReadablePartial)dt1.toLocalDateTime()).getDays();
    }
}

