/*
 * Decompiled with CFR 0.152.
 */
package com.eblly;

import com.eblly.HttpMethod;
import java.io.IOException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String request(String url, Map<String, String> params, HttpMethod httpMethod) {
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse httpResponse = null;
        String content = null;
        try {
            httpClient = HttpClients.createDefault();
            log.info("==>url:{}", (Object)url);
            HttpGet httpRequestBase = null;
            switch (httpMethod) {
                case GET: {
                    httpRequestBase = new HttpGet(url);
                    break;
                }
                case POST: {
                    httpRequestBase = new HttpPost(url);
                    break;
                }
                case DELETE: {
                    httpRequestBase = new HttpDelete(url);
                }
            }
            httpResponse = httpClient.execute(httpRequestBase);
            HttpEntity entity = httpResponse.getEntity();
            if (entity != null) {
                content = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                log.info("==>content: {}", (Object)content);
            }
        }
        catch (Exception e) {
            log.error("==>", (Throwable)e);
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                log.error("==>", (Throwable)e);
            }
            try {
                httpResponse.close();
            }
            catch (IOException e) {
                log.error("==>", (Throwable)e);
            }
        }
        return content;
    }
}

