/*
 * Decompiled with CFR 0.152.
 */
package com.eblly.mybatis;

import com.eblly.mybatis.Column;
import com.eblly.mybatis.Table;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.Modifier;
import org.apache.ibatis.io.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MybatisGenerateKit {
    private static final Logger log = LoggerFactory.getLogger(MybatisGenerateKit.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void build(String config, String tablePre, String mapperPackage, String modelPackage, String mapperTargt, String modelTarget, String mapperXmlTarget) throws Exception {
        InputStream stream = Resources.getResourceAsStream((String)config);
        Properties properties = new Properties();
        properties.load(stream);
        String jdbcDriver = properties.getProperty("jdbc.driver");
        String jdbcUrl = properties.getProperty("jdbc.url");
        String jdbcUserName = properties.getProperty("jdbc.username");
        String jdbcPassword = properties.getProperty("jdbc.password");
        Pattern p = Pattern.compile("/\\w+\\?");
        Matcher matcher = p.matcher(jdbcUrl);
        String tableSchema = null;
        if (!matcher.find()) {
            throw new Exception("\u672a\u5339\u914d\u5230\u6570\u636e\u5e93");
        }
        tableSchema = matcher.group(0);
        tableSchema = tableSchema.substring(1, tableSchema.length() - 1);
        Connection conn = null;
        Statement stmt = null;
        ArrayList<Table> tableList = new ArrayList<Table>();
        try {
            Class.forName(jdbcDriver);
            conn = DriverManager.getConnection(jdbcUrl, jdbcUserName, jdbcPassword);
            String tablesSql = " SELECT * FROM information_schema.TABLES WHERE TABLE_SCHEMA=? AND TABLE_NAME LIKE ?";
            stmt = conn.prepareStatement(tablesSql);
            stmt.setString(1, tableSchema);
            stmt.setString(2, tablePre + "%");
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                String tableName = rs.getString("TABLE_NAME");
                String tableComment = rs.getString("TABLE_COMMENT");
                Table table = new Table();
                table.setName(tableName);
                table.setComment(tableComment);
                tableList.add(table);
            }
            for (Table table : tableList) {
                String sql = " SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA=? AND TABLE_NAME=? order by ORDINAL_POSITION";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, tableSchema);
                stmt.setString(2, table.getName());
                rs = stmt.executeQuery();
                ResultSetMetaData rsmd = rs.getMetaData();
                ArrayList<Column> columnList = new ArrayList<Column>();
                while (rs.next()) {
                    String columnName = rs.getString("column_name");
                    String type = rs.getString("data_type");
                    String comment = rs.getString("column_comment");
                    Column column = new Column();
                    column.setName(columnName);
                    column.setType(type);
                    column.setComment(comment);
                    columnList.add(column);
                }
                table.setColumnList(columnList);
            }
            rs.close();
        }
        catch (Exception e) {
            log.error("==>error", (Throwable)e);
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
        this.generate(tableList, mapperPackage, modelPackage, mapperTargt, modelTarget, mapperXmlTarget);
    }

    private void generate(List<Table> tableList, String mapperPackage, String modelPackage, String mapperTargt, String modelTarget, String mapperXmlTarget) throws Exception {
        String javaMysqlProperties = "javaMysqlType.properties";
        InputStream stream = Resources.getResourceAsStream((String)javaMysqlProperties);
        Properties properties = new Properties();
        properties.load(stream);
        tableList.forEach(table -> {
            String tableName = table.getName();
            String modelName = MybatisGenerateKit.removeSplitChar(tableName);
            String modelNameFU = MybatisGenerateKit.firstCharUpCase(modelName);
            ArrayList<FieldSpec> fieldSpecList = new ArrayList<FieldSpec>();
            ArrayList<MethodSpec> methodSpecList = new ArrayList<MethodSpec>();
            LinkedHashMap<String, String> resultMap = new LinkedHashMap<String, String>();
            table.getColumnList().forEach(column -> {
                String columnName = column.getName();
                String fieldName = MybatisGenerateKit.removeSplitChar(columnName);
                String fieldNameFU = MybatisGenerateKit.firstCharUpCase(fieldName);
                if (!"id".equals(columnName)) {
                    resultMap.put(columnName, fieldName);
                }
                String type = column.getType();
                String comment = column.getComment();
                if (comment == null || "".equals(comment)) {
                    comment = "no comment";
                }
                Class<?> fieldType = null;
                try {
                    fieldType = Class.forName(properties.getProperty(type.toLowerCase()));
                }
                catch (NullPointerException e) {
                    log.error("==>{} \u672a\u627e\u5230\u8be5properties", (Object)type, (Object)e);
                }
                catch (ClassNotFoundException e) {
                    log.error("==>error", (Throwable)e);
                }
                FieldSpec field = FieldSpec.builder(fieldType, (String)fieldName, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).addJavadoc(comment + "\n", new Object[0]).build();
                fieldSpecList.add(field);
                MethodSpec getter = MethodSpec.methodBuilder((String)("get" + fieldNameFU)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(fieldType).addStatement("return " + fieldName, new Object[0]).build();
                methodSpecList.add(getter);
                MethodSpec setter = MethodSpec.methodBuilder((String)("set" + fieldNameFU)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(fieldType, fieldName, new Modifier[0]).addStatement("this.$N = $N", new Object[]{fieldName, fieldName}).build();
                methodSpecList.add(setter);
            });
            String basePath = new File("src/main/java").getPath();
            Configuration configuration = new Configuration();
            configuration.setDefaultEncoding("UTF-8");
            configuration.setClassForTemplateLoading(this.getClass(), "/ftl");
            this.generateModel((Table)table, modelNameFU, modelPackage, (List<FieldSpec>)fieldSpecList, (List<MethodSpec>)methodSpecList, basePath);
            try {
                this.generateMapperInterface((Table)table, modelName, modelNameFU, modelPackage, mapperPackage, basePath, configuration);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (TemplateException e) {
                e.printStackTrace();
            }
            try {
                this.generateMapperXml((Table)table, modelNameFU, modelPackage, mapperPackage, (Map<String, String>)resultMap, configuration);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private void generateModel(Table table, String modelNameFU, String modelPackage, List<FieldSpec> fieldSpecList, List<MethodSpec> methodSpecList, String basePath) {
        String javadoc = table.getComment();
        if (javadoc == null || "".equals(javadoc)) {
            javadoc = "no comment";
        }
        TypeSpec typeSpec = TypeSpec.classBuilder((String)modelNameFU).addModifiers(new Modifier[]{Modifier.PUBLIC}).addFields(fieldSpecList).addMethods(methodSpecList).addJavadoc(javadoc + "\n", new Object[0]).build();
        JavaFile model = JavaFile.builder((String)modelPackage, (TypeSpec)typeSpec).build();
        try {
            model.writeTo(new File(basePath));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void generateMapperInterface(Table table, String modelName, String modelNameFU, String modelPackage, String mapperPackage, String basePath, Configuration configuration) throws IOException, TemplateException {
        String mapperInterfacePath = basePath + "/" + mapperPackage.replace("\\.", File.separator);
        log.debug("==>modelMapperPath: {}", (Object)mapperInterfacePath);
        File mapperInterfaceDir = new File(mapperInterfacePath);
        File mapperInterface = new File(mapperInterfacePath + File.separator + modelNameFU + "Mapper.java");
        if (!mapperInterfaceDir.exists()) {
            mapperInterfaceDir.mkdirs();
            log.debug("==>create modelMapperDir");
        }
        if (!mapperInterface.exists()) {
            HashMap<String, String> dataMap = new HashMap<String, String>();
            dataMap.put("modelPackage", mapperPackage);
            dataMap.put("model", modelPackage + "." + modelNameFU);
            dataMap.put("modelNameFU", modelNameFU);
            dataMap.put("modelName", modelName);
            dataMap.put("comment", table.getComment());
            Template t = configuration.getTemplate("Mapper.ftl");
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(mapperInterface)));
            t.process(dataMap, (Writer)out);
        }
    }

    private void generateMapperXml(Table table, String modelNameFU, String modelPackage, String mapperPackage, Map<String, String> resultMap, Configuration configuration) throws Exception {
        String resultMapXMLPath = "src/main/resources/mapper/resultMap";
        String mapperXMLPath = "src/main/resources/mapper";
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        map2.put("resultMap", resultMap);
        map2.put("resultMapModel", modelPackage + "." + modelNameFU);
        map2.put("namespaceResultMap", mapperPackage + ".resultMap." + modelNameFU + "ResultMap");
        Template resutlMapFtl = configuration.getTemplate("ResultMapXML.ftl");
        File mapperResources = new File(resultMapXMLPath);
        if (!mapperResources.exists()) {
            mapperResources.mkdirs();
            log.debug("==>create mapperResources:{}", (Object)mapperResources);
        }
        File resultMapXMLFile = new File(resultMapXMLPath + File.separator + modelNameFU + "ResultMap.xml");
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(resultMapXMLFile)));
        resutlMapFtl.process(map2, (Writer)out);
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("namespace", mapperPackage + "." + modelNameFU + "Mapper");
        dataMap.put("selectResultMap", mapperPackage + ".resultMap." + modelNameFU + "ResultMap.resultMap");
        dataMap.put("table", table.getName());
        dataMap.put("resultMap", resultMap);
        dataMap.put("parameterType", modelNameFU);
        Template mapperFtl = configuration.getTemplate("MapperXML.ftl");
        File mapperXMLFile = new File(mapperXMLPath + File.separator + modelNameFU + "Mapper.xml");
        if (!mapperXMLFile.exists()) {
            BufferedWriter out2 = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(mapperXMLFile)));
            mapperFtl.process(dataMap, (Writer)out2);
        }
    }

    public static String removeSplitChar(String str) {
        String[] str2 = str.split("_");
        String removeStr = str2[0];
        for (int i = 1; i < str2.length; ++i) {
            String str3 = str2[i].substring(0, 1).toUpperCase() + str2[i].substring(1);
            removeStr = removeStr + str3;
        }
        return removeStr;
    }

    public static String firstCharUpCase(String word) {
        return word.substring(0, 1).toUpperCase() + word.substring(1);
    }
}

