/*
 * Decompiled with CFR 0.152.
 */
package com.github.andyczy.java.excel;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.ss.util.CellUtil;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelUtils {
    private static Logger log = LoggerFactory.getLogger(ExcelUtils.class);
    private static final ThreadLocal<SimpleDateFormat> fmt = new ThreadLocal();
    private static final String MESSAGE_FORMAT = "yyyy-MM-dd";
    private static final String DataValidationError1 = "\u672cExcel\u8868\u683c\u63d0\u9192\uff1a";
    private static final String DataValidationError2 = "\u6570\u636e\u4e0d\u89c4\u8303\uff0c\u8bf7\u9009\u62e9\u8868\u683c\u4e0b\u62c9\u5217\u8868\u4e2d\u7684\u6570\u636e\uff01";
    private static final ThreadLocal<DecimalFormat> df = new ThreadLocal();
    private static final String MESSAGE_FORMAT_df = "#.######";
    private static final ThreadLocal<ExcelUtils> UTILS_THREAD_LOCAL = new ThreadLocal();
    private List<List<String[]>> dataLists;
    private String[] sheetName;
    private String[] labelName;
    private HttpServletResponse response;
    private HashMap notBorderMap;
    private HashMap regionMap;
    private HashMap mapColumnWidth;
    private HashMap styles;
    private HashMap paneMap;
    private HashMap rowStyles;
    private HashMap columnStyles;
    private HashMap dropDownMap;
    private String fileName;
    private String filePath = this.getFilePath();

    private static final SimpleDateFormat getDateFormat() {
        SimpleDateFormat format = fmt.get();
        if (format == null) {
            format = new SimpleDateFormat(MESSAGE_FORMAT, Locale.getDefault());
            fmt.set(format);
        }
        return format;
    }

    private static final DecimalFormat getDecimalFormat() {
        DecimalFormat format = df.get();
        if (format == null) {
            format = new DecimalFormat(MESSAGE_FORMAT_df);
            df.set(format);
        }
        return format;
    }

    public static final ExcelUtils initialization() {
        ExcelUtils excelUtils = UTILS_THREAD_LOCAL.get();
        if (excelUtils == null) {
            excelUtils = new ExcelUtils();
            UTILS_THREAD_LOCAL.set(excelUtils);
        }
        return excelUtils;
    }

    public ExcelUtils() {
        this.dataLists = this.getDataLists();
        this.response = this.getResponse();
        this.notBorderMap = this.getNotBorderMap();
        this.regionMap = this.getRegionMap();
        this.mapColumnWidth = this.getMapColumnWidth();
        this.styles = this.getStyles();
        this.paneMap = this.getPaneMap();
        this.fileName = this.getFileName();
        this.sheetName = this.getSheetName();
        this.labelName = this.getLabelName();
        this.rowStyles = this.getRowStyles();
        this.columnStyles = this.getColumnStyles();
        this.dropDownMap = this.getDropDownMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean exportForExcelsOptimize() {
        long startTime = System.currentTimeMillis();
        log.info("Excel tool class export start run!");
        SXSSFWorkbook sxssfWorkbook = new SXSSFWorkbook(1000);
        OutputStream outputStream = null;
        SXSSFRow sxssfRow = null;
        try {
            ExcelUtils.setDataList(sxssfWorkbook, sxssfRow, this.dataLists, this.notBorderMap, this.regionMap, this.mapColumnWidth, this.styles, this.paneMap, this.sheetName, this.labelName, this.rowStyles, this.columnStyles, this.dropDownMap);
            ExcelUtils.setIo(sxssfWorkbook, outputStream, this.fileName, this.sheetName, this.response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        log.info("Excel tool class export run time:" + (System.currentTimeMillis() - startTime) + " ms!");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean exportForExcelsNoStyle() {
        long startTime = System.currentTimeMillis();
        log.info("Excel tool class export start run!");
        SXSSFWorkbook sxssfWorkbook = new SXSSFWorkbook(1000);
        OutputStream outputStream = null;
        SXSSFRow sxssfRow = null;
        try {
            ExcelUtils.setDataListNoStyle(sxssfWorkbook, sxssfRow, this.dataLists, this.notBorderMap, this.regionMap, this.mapColumnWidth, this.paneMap, this.sheetName, this.labelName, this.dropDownMap);
            ExcelUtils.setIo(sxssfWorkbook, outputStream, this.fileName, this.sheetName, this.response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        log.info("Excel tool class export run time:" + (System.currentTimeMillis() - startTime) + " ms!");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean testLocalNoStyleNoResponse() {
        long startTime = System.currentTimeMillis();
        log.info("Excel tool class export start run!");
        SXSSFWorkbook sxssfWorkbook = new SXSSFWorkbook(1000);
        OutputStream outputStream = null;
        SXSSFRow sxssfRow = null;
        try {
            ExcelUtils.setDataListNoStyle(sxssfWorkbook, sxssfRow, this.dataLists, this.notBorderMap, this.regionMap, this.mapColumnWidth, this.paneMap, this.sheetName, this.labelName, this.dropDownMap);
            ExcelUtils.setIo(sxssfWorkbook, outputStream, this.fileName, this.sheetName, this.filePath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        log.info("Excel tool class export run time:" + (System.currentTimeMillis() - startTime) + " ms!");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean exportForExcel(HttpServletResponse response, List<List<String[]>> dataLists, HashMap notBorderMap, HashMap regionMap, HashMap columnMap, HashMap styles, HashMap paneMap, String fileName, String[] sheetName, String[] labelName, HashMap rowStyles, HashMap columnStyles, HashMap dropDownMap) {
        long startTime = System.currentTimeMillis();
        log.info("Excel tool class export start run!");
        SXSSFWorkbook sxssfWorkbook = new SXSSFWorkbook(1000);
        OutputStream outputStream = null;
        SXSSFRow sxssfRow = null;
        try {
            ExcelUtils.setDataList(sxssfWorkbook, sxssfRow, dataLists, notBorderMap, regionMap, columnMap, styles, paneMap, sheetName, labelName, rowStyles, columnStyles, dropDownMap);
            ExcelUtils.setIo(sxssfWorkbook, outputStream, fileName, sheetName, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                log.debug("Andyczy ExcelUtils Exception Message\uff1aExcel tool class export exception !");
                e.printStackTrace();
            }
        }
        log.info("Excel tool class export run time:" + (System.currentTimeMillis() - startTime) + " ms!");
        return true;
    }

    public static List<List<LinkedHashMap<String, String>>> importForExcelData(Workbook book, String[] sheetName, HashMap indexMap, HashMap continueRowMap) {
        long startTime = System.currentTimeMillis();
        log.info("Excel tool class export start run!");
        try {
            ArrayList<List<LinkedHashMap<String, String>>> returnDataList = new ArrayList<List<LinkedHashMap<String, String>>>();
            for (int k = 0; k <= sheetName.length - 1; ++k) {
                Sheet sheet = book.getSheetAt(k);
                int rowCount = sheet.getLastRowNum() + 1;
                Row valueRow = null;
                ArrayList rowListValue = new ArrayList();
                LinkedHashMap<String, String> cellHashMap = null;
                int irow = 0;
                if (indexMap != null && indexMap.get(k + 1) != null) {
                    irow = Integer.valueOf(indexMap.get(k + 1).toString()) - 1;
                }
                for (int i = irow; i < rowCount; ++i) {
                    valueRow = sheet.getRow(i);
                    if (valueRow == null) continue;
                    if (continueRowMap != null && continueRowMap.get(k + 1) != null) {
                        int continueRowCount = 0;
                        Integer[] continueRow = (Integer[])continueRowMap.get(k + 1);
                        for (int w = 0; w <= continueRow.length - 1; ++w) {
                            Cell valueRowCell = valueRow.getCell(continueRow[w] - 1);
                            if (valueRowCell != null && !ExcelUtils.isBlank(valueRowCell.toString())) continue;
                            ++continueRowCount;
                        }
                        if (continueRowCount == continueRow.length) continue;
                    }
                    cellHashMap = new LinkedHashMap<String, String>();
                    for (int j = 0; j < valueRow.getLastCellNum(); ++j) {
                        cellHashMap.put(Integer.toString(j), ExcelUtils.getCellVal(valueRow.getCell(j)));
                    }
                    if (cellHashMap.size() <= 0) continue;
                    rowListValue.add(cellHashMap);
                }
                returnDataList.add(rowListValue);
            }
            log.info("Excel tool class export run time:" + (System.currentTimeMillis() - startTime) + " ms!");
            return returnDataList;
        }
        catch (Exception e) {
            log.debug("Andyczy ExcelUtils Exception Message\uff1aExcel tool class export exception !");
            e.printStackTrace();
            return null;
        }
    }

    private static void setDataList(SXSSFWorkbook wb, SXSSFRow sxssfRow, List<List<String[]>> dataLists, HashMap notBorderMap, HashMap regionMap, HashMap columnMap, HashMap styles, HashMap paneMap, String[] sheetName, String[] labelName, HashMap rowStyles, HashMap columnStyles, HashMap dropDownMap) throws Exception {
        if (dataLists == null) {
            log.debug("Andyczy ExcelUtils Exception Message\uff1aExport data(type:List<List<String[]>>) cannot be empty!");
        }
        if (sheetName == null) {
            log.debug("Andyczy ExcelUtils Exception Message\uff1aExport sheet(type:String[]) name cannot be empty!");
        }
        int k = 0;
        for (List<String[]> listRow : dataLists) {
            SXSSFSheet sxssfSheet = wb.createSheet();
            sxssfSheet.setDefaultColumnWidth(16);
            wb.setSheetName(k, sheetName[k]);
            CellStyle cellStyle = wb.createCellStyle();
            XSSFFont font = (XSSFFont)wb.createFont();
            int jRow = 0;
            if (labelName != null) {
                sxssfRow = sxssfSheet.createRow(0);
                Cell cell = CellUtil.createCell((Row)sxssfRow, (int)0, (String)labelName[k]);
                ExcelUtils.setMergedRegion(sxssfSheet, 0, 0, 0, listRow.get(0).length - 1);
                ExcelUtils.setLabelStyles(wb, cell, sxssfRow);
                jRow = 1;
            }
            Integer pane = 1;
            if (paneMap != null) {
                pane = (Integer)paneMap.get(k + 1) + (labelName != null ? 1 : 0);
                ExcelUtils.createFreezePane(sxssfSheet, pane);
            }
            if (regionMap != null) {
                ExcelUtils.setMergedRegion(sxssfSheet, (ArrayList)regionMap.get(k + 1));
            }
            if (dropDownMap != null) {
                ExcelUtils.setDataValidation(sxssfSheet, (List)dropDownMap.get(k + 1), listRow.size());
            }
            if (columnMap != null) {
                ExcelUtils.setColumnWidth(sxssfSheet, (HashMap)columnMap.get(k + 1));
            }
            ExcelUtils.setStyle(cellStyle, font);
            CellStyle cell_style = null;
            CellStyle row_style = null;
            CellStyle column_style = null;
            for (int i = 0; i < listRow.size(); ++i) {
                sxssfRow = sxssfSheet.createRow(jRow);
                for (int j = 0; j < listRow.get(i).length; ++j) {
                    Cell cell = CellUtil.createCell((Row)sxssfRow, (int)j, (String)listRow.get(i)[j]);
                    cell.setCellStyle(cellStyle);
                    try {
                        if (columnStyles != null && jRow >= pane && i <= 100000) {
                            if (jRow == pane && j == 0) {
                                column_style = cell.getRow().getSheet().getWorkbook().createCellStyle();
                            }
                            ExcelUtils.setExcelRowStyles(cell, column_style, wb, sxssfRow, (List)columnStyles.get(k + 1), j);
                        }
                        if (rowStyles != null && i <= 100000) {
                            if (i == 0 && j == 0) {
                                row_style = cell.getRow().getSheet().getWorkbook().createCellStyle();
                            }
                            ExcelUtils.setExcelRowStyles(cell, row_style, wb, sxssfRow, (List)rowStyles.get(k + 1), jRow);
                        }
                        if (styles == null || i > 100000) continue;
                        if (i == 0) {
                            cell_style = cell.getRow().getSheet().getWorkbook().createCellStyle();
                        }
                        ExcelUtils.setExcelStyles(cell, cell_style, wb, sxssfRow, (List)styles.get(k + 1), j, i);
                        continue;
                    }
                    catch (Exception e) {
                        log.debug("Andyczy ExcelUtils Exception Message\uff1aThe maximum number of cell styles was exceeded. You can define up to 4000 styles!");
                    }
                }
                ++jRow;
            }
            ++k;
        }
    }

    private static void setDataListNoStyle(SXSSFWorkbook wb, SXSSFRow sxssfRow, List<List<String[]>> dataLists, HashMap notBorderMap, HashMap regionMap, HashMap columnMap, HashMap paneMap, String[] sheetName, String[] labelName, HashMap dropDownMap) throws Exception {
        if (dataLists == null) {
            log.debug("Andyczy ExcelUtils Exception Message\uff1aExport data(type:List<List<String[]>>) cannot be empty!");
        }
        if (sheetName == null) {
            log.debug("Andyczy ExcelUtils Exception Message\uff1aExport sheet(type:String[]) name cannot be empty!");
        }
        int k = 0;
        for (List<String[]> listRow : dataLists) {
            SXSSFSheet sxssfSheet = wb.createSheet();
            wb.setSheetName(k, sheetName[k]);
            CellStyle cellStyle = wb.createCellStyle();
            XSSFFont font = (XSSFFont)wb.createFont();
            int jRow = 0;
            if (labelName != null) {
                sxssfRow = sxssfSheet.createRow(0);
                Cell cell = CellUtil.createCell((Row)sxssfRow, (int)0, (String)labelName[k]);
                ExcelUtils.setMergedRegion(sxssfSheet, 0, 0, 0, listRow.get(0).length - 1);
                ExcelUtils.setLabelStyles(wb, cell, sxssfRow);
                jRow = 1;
            }
            Integer pane = 1;
            if (paneMap != null) {
                pane = (Integer)paneMap.get(k + 1) + (labelName != null ? 1 : 0);
                ExcelUtils.createFreezePane(sxssfSheet, pane);
            }
            if (regionMap != null) {
                ExcelUtils.setMergedRegion(sxssfSheet, (ArrayList)regionMap.get(k + 1));
            }
            if (dropDownMap != null) {
                ExcelUtils.setDataValidation(sxssfSheet, (List)dropDownMap.get(k + 1), listRow.size());
            }
            if (columnMap != null) {
                ExcelUtils.setColumnWidth(sxssfSheet, (HashMap)columnMap.get(k + 1));
            }
            ExcelUtils.setStyle(cellStyle, font);
            for (int i = 0; i < listRow.size(); ++i) {
                sxssfRow = sxssfSheet.createRow(jRow);
                for (int j = 0; j < listRow.get(i).length; ++j) {
                    Cell cell = CellUtil.createCell((Row)sxssfRow, (int)j, (String)listRow.get(i)[j]);
                    cell.setCellStyle(cellStyle);
                }
                ++jRow;
            }
            ++k;
        }
    }

    private static void setIo(SXSSFWorkbook sxssfWorkbook, OutputStream outputStream, String fileName, String[] sheetName, HttpServletResponse response) throws Exception {
        try {
            if (response != null) {
                response.setHeader("Charset", "UTF-8");
                response.setHeader("Content-Type", "application/force-download");
                response.setHeader("Content-Type", "application/vnd.ms-excel");
                response.setHeader("Content-disposition", "attachment; filename=" + URLEncoder.encode(fileName == null ? sheetName[0] : fileName, "utf8") + ".xlsx");
                response.flushBuffer();
                outputStream = response.getOutputStream();
            }
            if (outputStream != null) {
                sxssfWorkbook.write(outputStream);
                sxssfWorkbook.dispose();
                outputStream.flush();
                outputStream.close();
            }
        }
        catch (Exception e) {
            System.out.println(" Andyczy ExcelUtils Exception Message\uff1aOutput stream is not empty !");
            e.getSuppressed();
        }
    }

    private static void setIo(SXSSFWorkbook sxssfWorkbook, OutputStream outputStream, String fileName, String[] sheetName, String filePath) throws Exception {
        try {
            if (filePath != null) {
                outputStream = new FileOutputStream(filePath);
            }
            if (outputStream != null) {
                sxssfWorkbook.write(outputStream);
                sxssfWorkbook.dispose();
                outputStream.flush();
                outputStream.close();
            }
        }
        catch (Exception e) {
            System.out.println(" Andyczy ExcelUtils Exception Message\uff1aOutput stream is not empty !");
            e.getSuppressed();
        }
    }

    private static void setExcelStyles(Cell cell, CellStyle cellStyle, SXSSFWorkbook wb, SXSSFRow sxssfRow, Integer fontSize, Boolean bold, Boolean center, Boolean isBorder, Boolean leftBoolean, Boolean rightBoolean, Integer fontColor, Integer height) {
        cellStyle.cloneStyleFrom(cell.getCellStyle());
        if (center != null && center.booleanValue()) {
            cellStyle.setAlignment(HorizontalAlignment.CENTER);
            cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        }
        if (rightBoolean != null && rightBoolean.booleanValue()) {
            cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            cellStyle.setAlignment(HorizontalAlignment.RIGHT);
        }
        if (leftBoolean != null && leftBoolean.booleanValue()) {
            cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            cellStyle.setAlignment(HorizontalAlignment.LEFT);
        }
        if (isBorder != null && isBorder.booleanValue()) {
            ExcelUtils.setBorder(cellStyle, isBorder);
        }
        XSSFFont font = (XSSFFont)wb.createFont();
        if (bold != null && bold.booleanValue()) {
            font.setBold(bold.booleanValue());
        }
        if (height != null) {
            sxssfRow.setHeight((short)(height * 2));
        }
        font.setFontName("\u5b8b\u4f53");
        font.setFontHeight(fontSize == null ? 12.0 : (double)fontSize.intValue());
        cellStyle.setFont((Font)font);
        font.setColor(IndexedColors.fromInt((int)(fontColor == null ? 8 : fontColor.intValue())).index);
        cell.setCellStyle(cellStyle);
    }

    private static void setExcelRowStyles(Cell cell, CellStyle cellStyle, SXSSFWorkbook wb, SXSSFRow sxssfRow, List<Object[]> rowstyleList, int rowIndex) {
        if (rowstyleList != null && rowstyleList.size() > 0) {
            Integer[] rowstyle = (Integer[])rowstyleList.get(1);
            for (int i = 0; i < rowstyle.length; ++i) {
                if (rowIndex != rowstyle[i]) continue;
                Boolean[] bool = (Boolean[])rowstyleList.get(0);
                Integer fontColor = null;
                Integer fontSize = null;
                Integer height = null;
                if (rowstyleList.size() >= 3) {
                    int leng = rowstyleList.get(2).length;
                    if (leng >= 1) {
                        fontColor = (Integer)rowstyleList.get(2)[0];
                    }
                    if (leng >= 2) {
                        fontSize = (Integer)rowstyleList.get(2)[1];
                    }
                    if (leng >= 3) {
                        height = (Integer)rowstyleList.get(2)[2];
                    }
                }
                ExcelUtils.setExcelStyles(cell, cellStyle, wb, sxssfRow, fontSize, (boolean)bool[3], (boolean)bool[0], (boolean)bool[4], (boolean)bool[2], (boolean)bool[1], fontColor, height);
            }
        }
    }

    private static void setExcelStyles(Cell cell, CellStyle cellStyle, SXSSFWorkbook wb, SXSSFRow sxssfRow, List<List<Object[]>> styles, int cellIndex, int rowIndex) {
        if (styles != null) {
            for (int z = 0; z < styles.size(); ++z) {
                List<Object[]> stylesList = styles.get(z);
                if (stylesList == null) continue;
                Boolean[] bool = (Boolean[])stylesList.get(0);
                Integer fontColor = null;
                Integer fontSize = null;
                Integer height = null;
                if (stylesList.size() >= 2) {
                    int leng = stylesList.get(1).length;
                    if (leng >= 1) {
                        fontColor = (Integer)stylesList.get(1)[0];
                    }
                    if (leng >= 2) {
                        fontSize = (Integer)stylesList.get(1)[1];
                    }
                    if (leng >= 3) {
                        height = (Integer)stylesList.get(1)[2];
                    }
                }
                for (int m = 2; m < stylesList.size(); ++m) {
                    Integer[] str = (Integer[])stylesList.get(m);
                    if (cellIndex + 1 != str[1] || rowIndex + 1 != str[0]) continue;
                    ExcelUtils.setExcelStyles(cell, cellStyle, wb, sxssfRow, fontSize, (boolean)bool[3], (boolean)bool[0], (boolean)bool[4], (boolean)bool[2], (boolean)bool[1], fontColor, height);
                }
            }
        }
    }

    private static void setLabelStyles(SXSSFWorkbook wb, Cell cell, SXSSFRow sxssfRow) {
        CellStyle cellStyle = wb.createCellStyle();
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        ExcelUtils.setBorder(cellStyle, true);
        sxssfRow.setHeight((short)798);
        XSSFFont font = (XSSFFont)wb.createFont();
        font.setFontName("\u5b8b\u4f53");
        font.setFontHeight(16.0);
        cellStyle.setFont((Font)font);
        cell.setCellStyle(cellStyle);
    }

    private static void setStyle(CellStyle cellStyle, XSSFFont font) {
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        font.setFontName("\u5b8b\u4f53");
        cellStyle.setFont((Font)font);
        font.setFontHeight(12.0);
        ExcelUtils.setBorder(cellStyle, true);
    }

    private static boolean isBlank(String str) {
        int strLen;
        if (str != null && (strLen = str.length()) != 0) {
            for (int i = 0; i < strLen; ++i) {
                if (Character.isWhitespace(str.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    private static void createFreezePane(SXSSFSheet sxssfSheet, Integer row) {
        if (row != null && row > 0) {
            sxssfSheet.createFreezePane(0, row.intValue(), 0, 1);
        }
    }

    private static void setColumnWidth(SXSSFSheet sxssfSheet, HashMap map) {
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                Object key = entry.getKey();
                Object val = entry.getValue();
                sxssfSheet.setColumnWidth(((Integer)key).intValue(), (Integer)val * 512);
            }
        }
    }

    private static void setMergedRegion(SXSSFSheet sheet, ArrayList<Integer[]> rowColList) {
        if (rowColList != null && rowColList.size() > 0) {
            for (int i = 0; i < rowColList.size(); ++i) {
                Integer[] str = rowColList.get(i);
                if (str.length <= 0 || str.length != 4) continue;
                Integer firstRow = str[0];
                Integer lastRow = str[1];
                Integer firstCol = str[2];
                Integer lastCol = str[3];
                ExcelUtils.setMergedRegion(sheet, firstRow, lastRow, firstCol, lastCol);
            }
        }
    }

    private static void setMergedRegion(SXSSFSheet sheet, int firstRow, int lastRow, int firstCol, int lastCol) {
        sheet.addMergedRegion(new CellRangeAddress(firstRow, lastRow, firstCol, lastCol));
    }

    private static void setDataValidation(SXSSFSheet sheet, List<String[]> dropDownListData, int dataListSize) {
        if (dropDownListData.size() > 0) {
            for (int col = 0; col < dropDownListData.get(0).length; ++col) {
                Integer colv = Integer.parseInt(dropDownListData.get(0)[col]);
                ExcelUtils.setDataValidation(sheet, dropDownListData.get(col + 1), 1, dataListSize < 100 ? 500 : dataListSize, colv, colv);
            }
        }
    }

    private static void setDataValidation(SXSSFSheet xssfWsheet, String[] list, Integer firstRow, Integer lastRow, Integer firstCol, Integer lastCol) {
        DataValidationHelper helper = xssfWsheet.getDataValidationHelper();
        CellRangeAddressList addressList = new CellRangeAddressList(firstRow.intValue(), lastRow.intValue(), firstCol.intValue(), lastCol.intValue());
        DataValidationConstraint constraint = helper.createExplicitListConstraint(list);
        DataValidation dataValidation = helper.createValidation(constraint, addressList);
        dataValidation.createErrorBox(DataValidationError1, DataValidationError2);
        if (dataValidation instanceof XSSFDataValidation) {
            dataValidation.setSuppressDropDownArrow(true);
            dataValidation.setShowErrorBox(true);
        } else {
            dataValidation.setSuppressDropDownArrow(false);
        }
        xssfWsheet.addValidationData(dataValidation);
    }

    private static void setBorder(CellStyle cellStyle, Boolean isBorder) {
        if (isBorder.booleanValue()) {
            cellStyle.setBorderBottom(BorderStyle.THIN);
            cellStyle.setBorderLeft(BorderStyle.THIN);
            cellStyle.setBorderTop(BorderStyle.THIN);
            cellStyle.setBorderRight(BorderStyle.THIN);
        }
    }

    private static String getCellVal(Cell cell) {
        String val = null;
        if (cell != null) {
            CellType cellType = cell.getCellTypeEnum();
            switch (cellType) {
                case NUMERIC: {
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        val = ExcelUtils.getDateFormat().format(cell.getDateCellValue());
                        break;
                    }
                    val = ExcelUtils.getDecimalFormat().format(cell.getNumericCellValue());
                    break;
                }
                case STRING: {
                    val = cell.getStringCellValue();
                    break;
                }
                case BOOLEAN: {
                    val = String.valueOf(cell.getBooleanCellValue());
                    break;
                }
                case BLANK: {
                    val = cell.getStringCellValue();
                    break;
                }
                case ERROR: {
                    val = "\u9519\u8bef";
                    break;
                }
                case FORMULA: {
                    try {
                        val = String.valueOf(cell.getStringCellValue());
                    }
                    catch (IllegalStateException e) {
                        val = String.valueOf(cell.getNumericCellValue());
                    }
                    break;
                }
                default: {
                    val = cell.getRichStringCellValue() == null ? null : cell.getRichStringCellValue().toString();
                    break;
                }
            }
        } else {
            val = "";
        }
        return val;
    }

    public List<List<String[]>> getDataLists() {
        return this.dataLists;
    }

    public void setDataLists(List<List<String[]>> dataLists) {
        this.dataLists = dataLists;
    }

    public String[] getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String[] sheetName) {
        this.sheetName = sheetName;
    }

    public String[] getLabelName() {
        return this.labelName;
    }

    public void setLabelName(String[] labelName) {
        this.labelName = labelName;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public void setResponse(HttpServletResponse response) {
        this.response = response;
    }

    public HashMap getNotBorderMap() {
        return this.notBorderMap;
    }

    public void setNotBorderMap(HashMap notBorderMap) {
        this.notBorderMap = notBorderMap;
    }

    public HashMap getRegionMap() {
        return this.regionMap;
    }

    public void setRegionMap(HashMap regionMap) {
        this.regionMap = regionMap;
    }

    public HashMap getMapColumnWidth() {
        return this.mapColumnWidth;
    }

    public void setMapColumnWidth(HashMap mapColumnWidth) {
        this.mapColumnWidth = mapColumnWidth;
    }

    public HashMap getStyles() {
        return this.styles;
    }

    public void setStyles(HashMap styles) {
        this.styles = styles;
    }

    public HashMap getPaneMap() {
        return this.paneMap;
    }

    public void setPaneMap(HashMap paneMap) {
        this.paneMap = paneMap;
    }

    public HashMap getRowStyles() {
        return this.rowStyles;
    }

    public void setRowStyles(HashMap rowStyles) {
        this.rowStyles = rowStyles;
    }

    public HashMap getColumnStyles() {
        return this.columnStyles;
    }

    public void setColumnStyles(HashMap columnStyles) {
        this.columnStyles = columnStyles;
    }

    public HashMap getDropDownMap() {
        return this.dropDownMap;
    }

    public void setDropDownMap(HashMap dropDownMap) {
        this.dropDownMap = dropDownMap;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }
}

