/*
 * Decompiled with CFR 0.152.
 */
package com.github.angleshq.angles.api.requests;

import com.github.angleshq.angles.api.exceptions.AnglesServerException;
import com.github.angleshq.angles.api.models.build.Artifact;
import com.github.angleshq.angles.api.models.build.Build;
import com.github.angleshq.angles.api.models.build.CreateBuild;
import com.github.angleshq.angles.api.models.build.StoreArtifacts;
import com.github.angleshq.angles.api.requests.BaseRequests;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import org.apache.http.client.methods.CloseableHttpResponse;

public class BuildRequests
extends BaseRequests {
    private String basePath = "build";

    public BuildRequests(String baseUrl) {
        super(baseUrl);
    }

    public Build create(CreateBuild createBuild) throws IOException, AnglesServerException {
        CloseableHttpResponse response = this.sendJSONPost(this.basePath, createBuild);
        return this.processResponse(response, Build.class);
    }

    public Build[] get(String teamId, Integer limit, Integer skip) throws IOException, URISyntaxException, AnglesServerException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("teamId", teamId);
        if (limit != null) {
            parameters.put("limit", limit);
        }
        if (skip != null) {
            parameters.put("skip", skip);
        }
        CloseableHttpResponse response = this.sendJSONGet(this.basePath, parameters);
        return this.processResponse(response, Build[].class);
    }

    public Build get(String buildId) throws IOException, AnglesServerException {
        CloseableHttpResponse response = this.sendJSONGet(this.basePath + "/" + buildId);
        return this.processResponse(response, Build.class);
    }

    public Boolean delete(String buildId) throws IOException, AnglesServerException {
        CloseableHttpResponse response = this.sendDelete(this.basePath + "/" + buildId);
        if (response.getStatusLine().getStatusCode() == 200) {
            return true;
        }
        this.processErrorResponse(response);
        return false;
    }

    public Build update(Build build) throws IOException, AnglesServerException {
        CloseableHttpResponse response = this.sendJSONPut(this.basePath + "/" + build.getId(), build);
        return this.processResponse(response, Build.class);
    }

    public Build keep(String buildId, Boolean keep) throws IOException, AnglesServerException {
        String request = "{ \"keep\": " + keep + " }";
        CloseableHttpResponse response = this.sendJSONPut(this.basePath + "/" + buildId + "/keep", request);
        return this.processResponse(response, Build.class);
    }

    public Build artifacts(String buildId, Artifact artifact) throws IOException, AnglesServerException {
        Artifact[] artifacts = new Artifact[]{artifact};
        return this.artifacts(buildId, artifacts);
    }

    public Build artifacts(String buildId, Artifact[] artifacts) throws IOException, AnglesServerException {
        StoreArtifacts request = new StoreArtifacts();
        request.setArtifacts(artifacts);
        CloseableHttpResponse response = this.sendJSONPut(this.basePath + "/" + buildId + "/artifacts", request);
        return this.processResponse(response, Build.class);
    }
}

