/*
 * Decompiled with CFR 0.152.
 */
package com.github.angleshq.angles.listeners.cucumber;

import com.github.angleshq.angles.assertion.junit.AnglesJUnit5Assert;
import com.github.angleshq.angles.basetest.AbstractAnglesTestCase;
import cucumber.api.Result;
import cucumber.api.TestCase;
import cucumber.api.TestStep;
import cucumber.api.event.EventHandler;
import cucumber.api.event.EventPublisher;
import cucumber.api.event.TestCaseFinished;
import cucumber.api.event.TestCaseStarted;
import cucumber.api.event.TestStepStarted;
import cucumber.api.formatter.Formatter;
import cucumber.runner.PickleTestStep;
import gherkin.pickles.PickleCell;
import gherkin.pickles.PickleRow;
import gherkin.pickles.PickleTable;

public class AnglesCucumber2Adapter
extends AbstractAnglesTestCase
implements Formatter {
    protected AnglesJUnit5Assert doAssert = new AnglesJUnit5Assert();
    protected EventHandler<TestStepStarted> handleTestStepFinished = new EventHandler<TestStepStarted>(){

        public void receive(TestStepStarted event) {
            TestStep testStep = event.testStep;
            if (testStep.getClass() == PickleTestStep.class) {
                String text = event.testStep.getStepText();
                AnglesCucumber2Adapter.this.anglesReporter.startAction(text);
                AnglesCucumber2Adapter.this.anglesReporter.info(text);
                String argumentTable = "\n";
                try {
                    PickleTable argument = (PickleTable)testStep.getStepArgument().get(0);
                    for (PickleRow row : argument.getRows()) {
                        argumentTable = argumentTable + "\n| ";
                        for (PickleCell cell : row.getCells()) {
                            argumentTable = argumentTable + cell.getValue() + " | ";
                        }
                    }
                    AnglesCucumber2Adapter.this.anglesReporter.info(argumentTable);
                }
                catch (Exception e) {
                    AnglesCucumber2Adapter.this.anglesReporter.info("Cannot show argument table: " + e.getMessage());
                }
            } else {
                String hookName = testStep.getHookType().name();
                if (hookName.equals("Before")) {
                    AnglesCucumber2Adapter.this.anglesReporter.startAction("Setup");
                    AnglesCucumber2Adapter.this.anglesReporter.info(hookName);
                } else if (hookName.equals("After")) {
                    AnglesCucumber2Adapter.this.anglesReporter.startAction("Cleanup");
                    AnglesCucumber2Adapter.this.anglesReporter.info(hookName);
                }
            }
        }
    };
    protected EventHandler<TestCaseStarted> handleTestCaseStarted = new EventHandler<TestCaseStarted>(){

        public void receive(TestCaseStarted event) {
            String[] featurePath = event.testCase.getScenarioDesignation().split(":");
            String featureName = featurePath[0];
            featurePath = featureName.split("/");
            featureName = featurePath[featurePath.length - 1];
            String testName = event.testCase.getName();
            AnglesCucumber2Adapter.this.anglesReporter.startTest(featureName, testName);
        }
    };
    protected EventHandler<TestCaseFinished> handleTestCaseFinished = new EventHandler<TestCaseFinished>(){

        public void receive(TestCaseFinished event) {
            TestCase testCase = event.testCase;
            Result result = event.result;
            Throwable error = result.getError();
            String scenarioName = testCase.getName();
            TestStep testStep = (TestStep)testCase.getTestSteps().get(0);
            String text = testStep.getHookType().toString();
            String id = "" + testCase.getUri() + testCase.getLine();
            System.out.println("Testcase " + id + " - " + result.getStatus());
            if (result.getStatus().equals((Object)Result.Type.PASSED)) {
                AnglesCucumber2Adapter.this.anglesReporter.pass(scenarioName + " passed!", "", "", "");
            }
            if (result.getStatus().equals((Object)Result.Type.FAILED)) {
                AnglesCucumber2Adapter.this.anglesReporter.fail(scenarioName + " failed!", "", event.result.getErrorMessage(), "Test has failed");
            }
            if (result.getStatus().equals((Object)Result.Type.SKIPPED)) {
                AnglesCucumber2Adapter.this.anglesReporter.fail(scenarioName + " skipped!", "", "", "Test NOT RUN");
            }
            AnglesCucumber2Adapter.this.anglesReporter.saveTest();
        }
    };

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestCaseFinished.class, this.handleTestCaseFinished);
        publisher.registerHandlerFor(TestCaseStarted.class, this.handleTestCaseStarted);
        publisher.registerHandlerFor(TestStepStarted.class, this.handleTestStepFinished);
    }
}

