/*
 * Decompiled with CFR 0.152.
 */
package com.github.angleshq.angles;

import com.github.angleshq.angles.AnglesReporterEmpty;
import com.github.angleshq.angles.AnglesReporterInterface;
import com.github.angleshq.angles.StepStatus;
import com.github.angleshq.angles.api.exceptions.AnglesServerException;
import com.github.angleshq.angles.api.models.Platform;
import com.github.angleshq.angles.api.models.build.Artifact;
import com.github.angleshq.angles.api.models.build.Build;
import com.github.angleshq.angles.api.models.build.CreateBuild;
import com.github.angleshq.angles.api.models.execution.Action;
import com.github.angleshq.angles.api.models.execution.CreateExecution;
import com.github.angleshq.angles.api.models.execution.Step;
import com.github.angleshq.angles.api.models.screenshot.CreateScreenshot;
import com.github.angleshq.angles.api.models.screenshot.ImageCompareResponse;
import com.github.angleshq.angles.api.models.screenshot.Screenshot;
import com.github.angleshq.angles.api.models.screenshot.ScreenshotDetails;
import com.github.angleshq.angles.api.requests.BuildRequests;
import com.github.angleshq.angles.api.requests.EnvironmentRequests;
import com.github.angleshq.angles.api.requests.ExecutionRequests;
import com.github.angleshq.angles.api.requests.ScreenshotRequests;
import com.github.angleshq.angles.api.requests.TeamRequests;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AnglesReporter
implements AnglesReporterInterface {
    public static final String DEFAULT_ACTION_NAME = "Test Details";
    public static final String EMPTY_REPORTER_NAME = "empty";
    private static Map<String, AnglesReporterInterface> reporterMap = new HashMap<String, AnglesReporterInterface>();
    private static boolean enabled = true;
    private String baseUrl;
    private BuildRequests buildRequests;
    private ExecutionRequests executionRequests;
    private EnvironmentRequests environmentRequests;
    private TeamRequests teamRequests;
    private ScreenshotRequests screenshotRequests;
    private InheritableThreadLocal<Build> currentBuild = new InheritableThreadLocal();
    private InheritableThreadLocal<CreateExecution> currentExecution = new InheritableThreadLocal();
    private InheritableThreadLocal<Action> currentAction = new InheritableThreadLocal();
    private ThreadLocal<Action> setUpAction = new InheritableThreadLocal<Action>();

    public static AnglesReporterInterface getInstance(String url) {
        if (!enabled) {
            if (!reporterMap.containsKey(EMPTY_REPORTER_NAME)) {
                reporterMap.put(EMPTY_REPORTER_NAME, new AnglesReporterEmpty());
            }
            return reporterMap.get(EMPTY_REPORTER_NAME);
        }
        if (!reporterMap.containsKey(url)) {
            reporterMap.put(url, new AnglesReporter(url));
        }
        return reporterMap.get(url);
    }

    private AnglesReporter(String url) {
        this.baseUrl = url;
        this.buildRequests = new BuildRequests(this.baseUrl);
        this.executionRequests = new ExecutionRequests(this.baseUrl);
        this.environmentRequests = new EnvironmentRequests(this.baseUrl);
        this.teamRequests = new TeamRequests(this.baseUrl);
        this.screenshotRequests = new ScreenshotRequests(this.baseUrl);
    }

    @Override
    public synchronized void startBuild(String name, String environmentName, String teamName, String componentName) {
        if (this.currentBuild.get() != null) {
            return;
        }
        CreateBuild createBuild = new CreateBuild();
        createBuild.setName(name);
        createBuild.setEnvironment(environmentName);
        createBuild.setTeam(teamName);
        createBuild.setComponent(componentName);
        createBuild.setStart(new Date());
        try {
            this.currentBuild.set(this.buildRequests.create(createBuild));
        }
        catch (AnglesServerException | IOException exception) {
            throw new Error("Unable to create build due to [" + exception.getMessage() + "]");
        }
    }

    @Override
    public synchronized void storeArtifacts(Artifact[] artifacts) {
        try {
            this.currentBuild.set(this.buildRequests.artifacts(((Build)this.currentBuild.get()).getId(), artifacts));
        }
        catch (AnglesServerException | IOException exception) {
            throw new Error("Unable to store build artifacts due to [" + exception.getMessage() + "]");
        }
    }

    @Override
    public void startTest(String suiteName, String testName) {
        this.startTest(suiteName, testName, null, null);
    }

    @Override
    public void updateTestName(String testName) {
        ((CreateExecution)this.currentExecution.get()).setTitle(testName);
    }

    @Override
    public void startTest(String suiteName, String testName, String feature) {
        this.startTest(suiteName, testName, feature, null);
    }

    @Override
    public void startTest(String suiteName, String testName, String feature, List<String> tags) {
        CreateExecution createExecution = new CreateExecution();
        createExecution.setStart(new Date());
        createExecution.setBuild(((Build)this.currentBuild.get()).getId());
        createExecution.setTitle(testName);
        createExecution.setSuite(suiteName);
        createExecution.setFeature(feature);
        createExecution.setTags(tags);
        this.currentExecution.set(createExecution);
        if (this.setUpAction.get() != null) {
            this.setUpAction.set(null);
        }
        this.currentAction.set(null);
    }

    @Override
    public void saveTest() {
        try {
            this.executionRequests.create((CreateExecution)this.currentExecution.get());
            this.currentExecution.set(null);
        }
        catch (AnglesServerException | IOException exception) {
            throw new Error("Unable to save/update test execution due to [" + exception.getMessage() + "]");
        }
    }

    @Override
    public void storePlatformDetails(Platform ... platform) {
        ((CreateExecution)this.currentExecution.get()).addPlatform(platform);
    }

    @Override
    public void startAction(String description) {
        this.currentAction.set(new Action(description));
        ((CreateExecution)this.currentExecution.get()).getActions().add((Action)this.currentAction.get());
    }

    @Override
    public void debug(String debug) {
        this.addStep("debug", null, null, debug, StepStatus.DEBUG, null);
    }

    @Override
    public void debug(String debug, String screenshotId) {
        this.addStep("debug", null, null, debug, StepStatus.DEBUG, screenshotId);
    }

    @Override
    public void error(String error) {
        this.addStep("error", null, null, error, StepStatus.ERROR, null);
    }

    @Override
    public void error(String error, String screenshotId) {
        this.addStep("error", null, null, error, StepStatus.ERROR, screenshotId);
    }

    @Override
    public void info(String info) {
        this.addStep("info", null, null, info, StepStatus.INFO, null);
    }

    @Override
    public void info(String info, String screenshotId) {
        this.addStep("info", null, null, info, StepStatus.INFO, screenshotId);
    }

    @Override
    public void pass(String name, String expected, String actual, String info) {
        this.addStep(name, expected, actual, info, StepStatus.PASS, null);
    }

    @Override
    public void pass(String name, String expected, String actual, String info, String screenshotId) {
        this.addStep(name, expected, actual, info, StepStatus.PASS, screenshotId);
    }

    @Override
    public void fail(String name, String expected, String actual, String info) {
        this.addStep(name, expected, actual, info, StepStatus.FAIL);
    }

    @Override
    public void fail(String name, String expected, String actual, String info, String screenshotId) {
        this.addStep(name, expected, actual, info, StepStatus.FAIL, screenshotId);
    }

    private void addStep(String name, String expected, String actual, String info, StepStatus status) {
        this.addStep(name, expected, actual, info, status, null);
    }

    private void addStep(String name, String expected, String actual, String info, StepStatus status, String screenshotId) {
        Step step = new Step();
        step.setTimestamp(new Date());
        step.setStatus(status);
        step.setName(name);
        step.setExpected(expected);
        step.setActual(actual);
        step.setInfo(info);
        if (screenshotId != null) {
            step.setScreenshot(screenshotId);
        }
        if (this.currentExecution.get() == null) {
            if (this.setUpAction.get() == null) {
                this.setUpAction.set(new Action("Test-Setup"));
            }
            this.setUpAction.get().addStep(step);
        } else {
            if (this.currentAction.get() == null) {
                this.startAction(DEFAULT_ACTION_NAME);
            }
            ((Action)this.currentAction.get()).addStep(step);
        }
    }

    @Override
    public Screenshot storeScreenshot(ScreenshotDetails details) {
        CreateScreenshot createScreenshot = new CreateScreenshot();
        createScreenshot.setBuildId(((Build)this.currentBuild.get()).getId());
        createScreenshot.setTimestamp(new Date());
        createScreenshot.setView(details.getView());
        createScreenshot.setFilePath(details.getPath());
        createScreenshot.setPlatform(details.getPlatform());
        createScreenshot.setTags(details.getTags());
        try {
            Screenshot response = this.screenshotRequests.create(createScreenshot);
            return response;
        }
        catch (AnglesServerException | IOException exception) {
            throw new Error("Unable store screenshot due to [" + exception.getMessage() + "]");
        }
    }

    @Override
    public ImageCompareResponse compareScreenshotAgainstBaseline(String screenshotId) {
        try {
            return this.screenshotRequests.baselineCompare(screenshotId);
        }
        catch (IOException exception) {
            throw new Error("Unable compare screenshot with baseline due to [" + exception.getMessage() + "]");
        }
        catch (AnglesServerException exception) {
            if (!exception.getHttpStatusCode().equals(404) || !exception.getMessage().contains("No baselines")) {
                throw new Error("Unable compare screenshot with baseline due to [" + exception.getMessage() + "]");
            }
            this.info("Unable to compare screenshot [" + screenshotId + "] against baseline as it has not been set. Please set a baseline using the Angles UI.");
            return null;
        }
    }

    public static void setEnabled(boolean enabled) {
        AnglesReporter.enabled = enabled;
    }

    public static boolean isEnabled() {
        return enabled;
    }
}

