package timber.log;

public enum Level {

    OFF(0, ""),
    FATAL(1, "FATAL"),
    ERROR(2, "ERROR"),
    WARN(3, "WARN"),
    INFO(4, "INFO"),
    DEBUG(5, "DEBUG"),
    TRACE(6, "TRACE");

    private final String levelName;
    private final Integer levelCode;

    Level(Integer levelCode, String levelName){
        this.levelCode = levelCode;
        this.levelName = levelName;
    }

    public Integer getLevelCode() {
        return levelCode;
    }

    public String getLevelName() {
        return levelName;
    }
}
