/*
 * Decompiled with CFR 0.152.
 */
package timber.log;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NonNls;
import timber.log.Level;
import timber.log.trees.Tree;

public class Timber {
    private static final List<Tree> FOREST = new CopyOnWriteArrayList<Tree>();
    private static final Tree TREE_OF_SOULS = new Tree(){

        @Override
        public void trace(String message, Object ... args) {
            FOREST.forEach(tree -> tree.trace(message, args));
        }

        @Override
        public void trace(Throwable t, String message, Object ... args) {
            FOREST.forEach(tree -> tree.trace(t, message, args));
        }

        @Override
        public void debug(String message, Object ... args) {
            FOREST.forEach(tree -> tree.debug(message, args));
        }

        @Override
        public void debug(Throwable t, String message, Object ... args) {
            FOREST.forEach(tree -> tree.trace(t, message, args));
        }

        @Override
        public void info(String message, Object ... args) {
            FOREST.forEach(tree -> tree.info(message, args));
        }

        @Override
        public void info(Throwable t, String message, Object ... args) {
            FOREST.forEach(tree -> tree.info(t, message, args));
        }

        @Override
        public void warn(String message, Object ... args) {
            FOREST.forEach(tree -> tree.warn(message, args));
        }

        @Override
        public void warn(Throwable t, String message, Object ... args) {
            FOREST.forEach(tree -> tree.warn(t, message, args));
        }

        @Override
        public void error(String message, Object ... args) {
            FOREST.forEach(tree -> tree.error(message, args));
        }

        @Override
        public void error(Throwable t, String message, Object ... args) {
            FOREST.forEach(tree -> tree.error(t, message, args));
        }

        @Override
        public void fatal(String message, Object ... args) {
            FOREST.forEach(tree -> tree.fatal(message, args));
        }

        @Override
        public void fatal(Throwable t, String message, Object ... args) {
            FOREST.forEach(tree -> tree.fatal(t, message, args));
        }

        @Override
        public void log(Level level, String message, Object ... args) {
            FOREST.forEach(tree -> tree.log(level, message, args));
        }

        @Override
        public void log(Level level, Throwable t, String message, Object ... args) {
            FOREST.forEach(tree -> tree.log(level, t, message, args));
        }

        @Override
        protected void log(Level level, String tag, String message, Throwable t) {
            throw new AssertionError((Object)"Missing override for method Tree.log(Level, String, String, Throwable)");
        }
    };

    public static void trace(@NonNls String message, Object ... args) {
        TREE_OF_SOULS.trace(message, args);
    }

    public static void trace(Throwable throwable, @NonNls String message, Object ... args) {
        TREE_OF_SOULS.trace(throwable, message, args);
    }

    public static void debug(@NonNls String message, Object ... args) {
        TREE_OF_SOULS.debug(message, args);
    }

    public static void debug(Throwable throwable, @NonNls String message, Object ... args) {
        TREE_OF_SOULS.debug(throwable, message, args);
    }

    public static void info(@NonNls String message, Object ... args) {
        TREE_OF_SOULS.info(message, args);
    }

    public static void info(Throwable throwable, @NonNls String message, Object ... args) {
        TREE_OF_SOULS.info(throwable, message, args);
    }

    public static void warn(@NonNls String message, Object ... args) {
        TREE_OF_SOULS.warn(message, args);
    }

    public static void warn(Throwable throwable, @NonNls String message, Object ... args) {
        TREE_OF_SOULS.warn(throwable, message, args);
    }

    public static void error(@NonNls String message, Object ... args) {
        TREE_OF_SOULS.error(message, args);
    }

    public static void error(Throwable throwable, @NonNls String message, Object ... args) {
        TREE_OF_SOULS.error(throwable, message, args);
    }

    public static void fatal(@NonNls String message, Object ... args) {
        TREE_OF_SOULS.fatal(message, args);
    }

    public static void fatal(Throwable throwable, @NonNls String message, Object ... args) {
        TREE_OF_SOULS.fatal(throwable, message, args);
    }

    public static void log(Level level, @NonNls String message, Object ... args) {
        TREE_OF_SOULS.log(level, message, args);
    }

    public static void log(Level level, Throwable throwable, @NonNls String message, Object ... args) {
        TREE_OF_SOULS.log(level, throwable, message, args);
    }

    public static Tree asTree() {
        return TREE_OF_SOULS;
    }

    public static Tree tag(String tag) {
        FOREST.forEach(tree -> tree.setTag(tag));
        return TREE_OF_SOULS;
    }

    public static void applyDateFormat(String pattern) {
        FOREST.forEach(tree -> tree.applyDateFormat(pattern));
    }

    public static void plant(Tree tree) {
        if (tree == null) {
            throw new NullPointerException("NULL argument given for Timber.plant(Tree)");
        }
        if (tree == TREE_OF_SOULS) {
            throw new IllegalArgumentException("Tried to plant Timber into itself");
        }
        FOREST.add(tree);
    }

    public static void uproot(Tree tree) {
        if (!FOREST.remove(tree)) {
            throw new IllegalArgumentException("Cannot uproot tree witch is not planted" + tree);
        }
    }

    public static void uprootAll() {
        FOREST.clear();
    }

    public static List<Tree> forest() {
        return Collections.unmodifiableList(FOREST);
    }

    public static int treeCount() {
        return FOREST.size();
    }

    private Timber() {
        throw new AssertionError((Object)"No instances available for Timber.<init>()");
    }
}

