/*
 * Decompiled with CFR 0.152.
 */
package timber.log.trees;

import timber.log.Level;
import timber.log.trees.Tree;

public class DebugTree
extends Tree {
    private static final int MAX_LOG_LENGTH = 4000;
    private static final int CALL_STACK_INDEX = 8;
    private final Level MIN_LEVEL;

    public DebugTree() {
        this(Level.TRACE);
    }

    public DebugTree(Level level) {
        this.MIN_LEVEL = level;
    }

    @Override
    protected boolean isLoggeable(Level level) {
        return Level.compare(this.MIN_LEVEL, level) >= 0;
    }

    @Override
    protected String getTag() {
        String tag = super.getTag();
        if (tag != null) {
            return tag;
        }
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        if (stackTrace.length <= 8) {
            throw new IllegalStateException("Not enough elements in stacktrace. Are you using synthetic stacktrace ?");
        }
        return this.createStackElementTag(stackTrace[8]);
    }

    @Override
    protected void log(Level level, String tag, String message, Throwable t) {
        if (!this.isLoggeable(level)) {
            return;
        }
        if (message.length() < 4000) {
            System.out.println(this.formatLine(level, tag, message));
            return;
        }
        int length = message.length();
        for (int i = 0; i < length; ++i) {
            int end;
            int newline = message.indexOf(10, i);
            newline = newline != -1 ? newline : length;
            do {
                end = Math.min(newline, i + 4000);
                System.out.println(this.formatLine(level, tag, message.substring(i, end)));
            } while ((i = end) < newline);
        }
    }
}

