/*
 * Decompiled with CFR 0.152.
 */
package timber.log.trees;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import timber.log.Level;
import timber.log.trees.Tree;

public class FileTree
extends Tree {
    private final PrintWriter PRINT_WRITER;
    private static final Pattern ANONYMOUS_CLASS = Pattern.compile("(\\$\\d+)+$");
    private final Level MIN_LEVEL;

    public FileTree(Level level, File logFile, boolean append) throws IOException {
        if (level == null) {
            level = Level.TRACE;
        }
        this.MIN_LEVEL = level;
        if (logFile == null) {
            logFile = new File("timber.log");
        }
        if (!logFile.exists()) {
            logFile.createNewFile();
        }
        if (!append || logFile.isDirectory()) {
            logFile.delete();
            logFile.createNewFile();
        }
        this.PRINT_WRITER = new PrintWriter(new FileOutputStream(logFile));
    }

    public FileTree(Level level, File logFile) throws IOException {
        this(level, logFile, false);
    }

    public FileTree(File file) throws IOException {
        this(Level.TRACE, file, false);
    }

    @Override
    protected String getTag() {
        String tag = super.getTag();
        if (tag != null) {
            return tag;
        }
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        if (stackTrace.length <= 8) {
            throw new IllegalStateException("Not enough elements in stacktrace. Are you using an obfuscator?");
        }
        return this.createStackElementTag(stackTrace[8]);
    }

    @Override
    protected boolean isLoggeable(Level level) {
        return Level.compare(this.MIN_LEVEL, level) >= 0;
    }

    @Override
    protected void log(Level level, String tag, String message, Throwable t) {
        if (!this.isLoggeable(level)) {
            return;
        }
        this.PRINT_WRITER.println(this.formatLine(level, tag, message));
        this.PRINT_WRITER.flush();
    }

    @Override
    protected String createStackElementTag(StackTraceElement element) {
        String tag = element.getClassName();
        Matcher m = ANONYMOUS_CLASS.matcher(tag);
        if (m.find()) {
            tag = m.replaceAll("");
        }
        return tag.substring(tag.lastIndexOf(46) + 1).replaceAll("\\$", ".");
    }
}

