/*
 * Decompiled with CFR 0.152.
 */
package timber.log.trees;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import timber.log.Level;
import timber.log.trees.Tree;

public class OutputStreamTree
extends Tree
implements Closeable {
    private final Level MIN_LEVEL;
    private final OutputStream OUTPUT_STREAM;
    private final boolean AUTOFLUSH;

    public OutputStreamTree(OutputStream stream) {
        this(Level.TRACE, stream, true);
    }

    public OutputStreamTree(Level level, OutputStream stream) {
        this(level, stream, true);
    }

    public OutputStreamTree(OutputStream stream, boolean autoflush) {
        this(Level.TRACE, stream, autoflush);
    }

    public OutputStreamTree(Level minLevel, OutputStream outputStream, boolean autoflush) {
        this.MIN_LEVEL = minLevel;
        this.OUTPUT_STREAM = outputStream;
        this.AUTOFLUSH = autoflush;
    }

    @Override
    protected boolean isLoggeable(Level level) {
        return Level.compare(this.MIN_LEVEL, level) >= 0;
    }

    @Override
    protected void log(Level level, String tag, String message, Throwable t) {
        if (!this.isLoggeable(level)) {
            return;
        }
        try {
            this.OUTPUT_STREAM.write(this.formatLine(level, tag, message).getBytes(Charset.forName("UTF-8")));
            if (this.AUTOFLUSH) {
                this.OUTPUT_STREAM.flush();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void close() throws IOException {
        this.OUTPUT_STREAM.close();
    }
}

