/*
 * Decompiled with CFR 0.152.
 */
package timber.log.trees;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import timber.log.Level;

public abstract class Tree {
    private final ThreadLocal<String> TAG = new ThreadLocal();
    private static final Pattern ANONYMOUS_CLASS = Pattern.compile("(\\$\\d+)+$");
    protected final String NL = System.lineSeparator();
    private static final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.SSS");

    protected String getTag() {
        String tag = this.TAG.get();
        if (tag != null) {
            this.TAG.remove();
        }
        return tag;
    }

    public void setTag(String tag) {
        this.TAG.set(tag);
    }

    public void trace(String message, Object ... args) {
        this.prepareLog(Level.TRACE, null, message, args);
    }

    public void trace(Throwable t, String message, Object ... args) {
        this.prepareLog(Level.TRACE, t, message, args);
    }

    public void debug(String message, Object ... args) {
        this.prepareLog(Level.DEBUG, null, message, args);
    }

    public void debug(Throwable t, String message, Object ... args) {
        this.prepareLog(Level.DEBUG, t, message, args);
    }

    public void info(String message, Object ... args) {
        this.prepareLog(Level.INFO, null, message, args);
    }

    public void info(Throwable t, String message, Object ... args) {
        this.prepareLog(Level.INFO, t, message, args);
    }

    public void warn(String message, Object ... args) {
        this.prepareLog(Level.WARN, null, message, args);
    }

    public void warn(Throwable t, String message, Object ... args) {
        this.prepareLog(Level.WARN, t, message, args);
    }

    public void error(String message, Object ... args) {
        this.prepareLog(Level.ERROR, null, message, args);
    }

    public void error(Throwable t, String message, Object ... args) {
        this.prepareLog(Level.ERROR, t, message, args);
    }

    public void fatal(String message, Object ... args) {
        this.prepareLog(Level.FATAL, null, message, args);
    }

    public void fatal(Throwable t, String message, Object ... args) {
        this.prepareLog(Level.FATAL, t, message, args);
    }

    public void log(Level level, String message, Object ... args) {
        this.prepareLog(level, null, message, args);
    }

    public void log(Level level, Throwable t, String message, Object ... args) {
        this.prepareLog(level, t, message, args);
    }

    protected boolean isLoggeable(Level level) {
        return true;
    }

    protected void prepareLog(Level level, Throwable t, String message, Object ... args) {
        if (!this.isLoggeable(level)) {
            return;
        }
        if (message != null && message.length() == 0) {
            message = null;
        }
        if (message == null) {
            if (t == null) {
                return;
            }
            message = this.getStackTraceString(t);
        } else {
            if (args.length > 0) {
                message = String.format(message, args);
            }
            if (t != null) {
                message = message + this.NL + this.getStackTraceString(t);
            }
        }
        this.log(level, this.getTag(), message, t);
    }

    protected final String getStackTraceString(Throwable t) {
        StringWriter stringWriter = new StringWriter(256);
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, false);
        t.printStackTrace(printWriter);
        printWriter.flush();
        printWriter.close();
        return stringWriter.toString();
    }

    protected String createStackElementTag(StackTraceElement element) {
        String tag = element.getClassName();
        Matcher m = ANONYMOUS_CLASS.matcher(tag);
        if (m.find()) {
            tag = m.replaceAll("");
        }
        return tag.substring(tag.lastIndexOf(46) + 1).replaceAll("\\$", ".");
    }

    protected String formatLine(Level level, String tag, String message) {
        return String.format("[%s][%s/%s]: %s", SIMPLE_DATE_FORMAT.format(new Date()), level.getLevelName().toUpperCase(), tag, message);
    }

    public final void applyDateFormat(String pattern) {
        SIMPLE_DATE_FORMAT.applyPattern(pattern);
    }

    protected abstract void log(Level var1, String var2, String var3, Throwable var4);
}

