/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.charmap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sk.antons.charmap.SequenceCharMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BTCharMapper
extends SequenceCharMapper {
    protected char noneChar = '\u0000';

    public BTCharMapper(String fromChars, String toChars) {
        super(fromChars, toChars);
        this.noneChar = '\u0000';
    }

    public BTCharMapper(String fromChars, String toChars, char noneChar) {
        super(fromChars, toChars);
        this.noneChar = noneChar;
    }

    public char getNoneChar() {
        return this.noneChar;
    }

    private static void setItem(List<Character> list, int index, Character c) {
        while (list.size() <= index) {
            list.add(null);
        }
        Character cc = list.set(index, c);
        if (cc != null) {
            throw new IllegalArgumentException("Conflict with character '" + c + "' and '" + cc + "'");
        }
    }

    private static void convertLinearToBT(List<Character> linearChars, List<Character> btChars, int startIndex, int endIndex, int toIndex) {
        if (startIndex > endIndex) {
            return;
        }
        if (startIndex == endIndex) {
            Character c = linearChars.get(startIndex);
            BTCharMapper.setItem(btChars, toIndex, c);
            return;
        }
        int middleIndex = (startIndex + endIndex) / 2;
        if ((startIndex + endIndex) % 2 > 0) {
            ++middleIndex;
        }
        Character c = linearChars.get(middleIndex);
        BTCharMapper.setItem(btChars, toIndex, c);
        BTCharMapper.convertLinearToBT(linearChars, btChars, startIndex, middleIndex - 1, toIndex * 2 + 1);
        BTCharMapper.convertLinearToBT(linearChars, btChars, middleIndex + 1, endIndex, toIndex * 2 + 2);
    }

    public static String[] convertLinearToBT(String fromChars, String toChars, char noneChar) {
        char c;
        int i;
        SequenceCharMapper translator = new SequenceCharMapper(fromChars, toChars);
        ArrayList<Character> list = new ArrayList<Character>();
        for (i = 0; i < fromChars.length(); ++i) {
            c = fromChars.charAt(i);
            list.add(Character.valueOf(c));
        }
        Collections.sort(list);
        for (i = 0; i < list.size() - 1; ++i) {
            char cc;
            c = ((Character)list.get(i)).charValue();
            if (c != (cc = ((Character)list.get(i + 1)).charValue())) continue;
            throw new IllegalArgumentException("Duplicite char '" + c + "' in fromChars.");
        }
        ArrayList<Character> newlist = new ArrayList<Character>();
        BTCharMapper.convertLinearToBT(list, newlist, 0, list.size() - 1, 0);
        char[] source = new char[newlist.size()];
        for (int i2 = 0; i2 < source.length; ++i2) {
            Character c2 = (Character)newlist.get(i2);
            source[i2] = c2 == null ? noneChar : c2.charValue();
        }
        String newFrom = new String(source);
        String newTo = translator.map(newFrom);
        return new String[]{newFrom, newTo};
    }

    @Override
    protected int findFromIndex(char c) {
        int len = this.fromChars.length;
        int index = 0;
        while (index < len) {
            char cc = this.fromChars[index];
            if (c == cc) {
                return index;
            }
            if (c < cc) {
                index = index * 2 + 1;
                continue;
            }
            index = index * 2 + 2;
        }
        return -1;
    }

    public static BTCharMapper instance(String fromChars, String toChars) {
        return new BTCharMapper(fromChars, toChars);
    }

    public static BTCharMapper instance(String fromChars, String toChars, String removeChars) {
        BTCharMapper mapper = new BTCharMapper(fromChars, toChars);
        mapper.setRemoveChars(removeChars);
        return mapper;
    }
}

