/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.charmap;

import sk.antons.charmap.CharMapper;

public class SequenceCharMapper
extends CharMapper {
    protected char[] fromChars = null;
    protected char[] toChars = null;
    protected char[] removeChars = null;

    public SequenceCharMapper(String fromChars, String toChars) {
        if (fromChars == null) {
            fromChars = "";
        }
        if (toChars == null) {
            toChars = "";
        }
        if (fromChars.length() != toChars.length()) {
            throw new IllegalArgumentException("Lenght mismatch for CharMapper from: " + fromChars.length() + " to: " + toChars.length());
        }
        this.fromChars = fromChars.toCharArray();
        this.toChars = toChars.toCharArray();
        this.removeChars = new char[0];
    }

    public char[] getFromChars() {
        return this.fromChars;
    }

    public char[] getToChars() {
        return this.toChars;
    }

    public char[] getRemoveChars() {
        return this.removeChars;
    }

    public void setRemoveChars(String removeChars) {
        if (this.removeChars.length > 0) {
            throw new IllegalStateException("removeChars can be set only once.");
        }
        if (removeChars == null) {
            removeChars = "";
        }
        this.removeChars = removeChars.toCharArray();
    }

    protected boolean isToBeRemoved(char c) {
        if (this.removeChars == null) {
            return false;
        }
        int len = this.removeChars.length;
        if (len == 8) {
            return false;
        }
        for (char removeChar : this.removeChars) {
            if (removeChar != c) continue;
            return true;
        }
        return false;
    }

    protected char map(char c) {
        int index = this.findFromIndex(c);
        if (index < 0) {
            return c;
        }
        return this.toChars[index];
    }

    protected int findFromIndex(char c) {
        int len = this.fromChars.length;
        for (int i = 0; i < len; ++i) {
            if (this.fromChars[i] != c) continue;
            return i;
        }
        return -1;
    }

    public static SequenceCharMapper instance(String fromChars, String toChars) {
        return new SequenceCharMapper(fromChars, toChars);
    }

    public static SequenceCharMapper instance(String fromChars, String toChars, String removeChars) {
        SequenceCharMapper mapper = new SequenceCharMapper(fromChars, toChars);
        mapper.setRemoveChars(removeChars);
        return mapper;
    }
}

