/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.jalw;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import sk.antons.jalw.JalwLogger;
import sk.antons.jalw.ctx.ThreadCtx;
import sk.antons.jalw.util.Appender;
import sk.antons.jalw.util.Checker;
import sk.antons.jalw.util.Show;
import sk.antons.jalw.util.StackTrace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jalw {
    protected static final int TYPE_NONE = 0;
    protected static final int TYPE_SIMPLE = 1;
    protected static final int TYPE_SLF = 2;
    protected static final int TYPE_PRINTF = 3;
    protected static final int TYPE_TOSTRING = 4;
    protected JalwLogger logger = null;
    protected String methodName = null;
    protected Object[] params = null;
    protected List<Event> history = null;
    protected boolean historyNotInitiated = true;
    protected boolean historyEnabled = false;
    protected int historySize = 50;
    protected boolean noMethodInfo = false;
    protected long starttime = System.currentTimeMillis();

    public Jalw(JalwLogger logger) {
        this.logger = logger;
    }

    private void addMethodInfo(StringBuilder sb, long time) {
        if (this.noMethodInfo) {
            return;
        }
        sb.append("  {").append(this.methodName);
        sb.append(" - ms: ").append(time - this.starttime);
        sb.append('}');
    }

    private String format(String msg, Object[] params) {
        if (params != null) {
            StringBuilder sb = new StringBuilder();
            int pos = 0;
            for (Object param : params) {
                int newpos = msg.indexOf("{}", pos);
                if (newpos < 0) break;
                sb.append(msg.substring(pos, newpos));
                sb.append(param);
                pos = newpos + 2;
            }
            sb.append(msg.substring(pos));
            msg = sb.toString();
        }
        return msg;
    }

    private String concat(Object[] params) {
        StringBuilder sb = new StringBuilder();
        if (params != null) {
            for (Object param : params) {
                sb.append(param);
            }
        }
        return sb.toString();
    }

    private String formatf(String msg, Object[] params) {
        if (params != null) {
            StringBuilder sb = new StringBuilder();
            Formatter f = new Formatter(sb);
            f.format(msg, params);
            msg = sb.toString();
        }
        return msg;
    }

    private String format(String msg, Object[] params, Object printable, long time, int type) {
        StringBuilder sb = new StringBuilder();
        if (type == 4) {
            sb.append(printable);
        } else if (type == 2) {
            sb.append(this.format(msg, params));
        } else if (type == 3) {
            sb.append(this.formatf(msg, params));
        } else {
            sb.append(msg);
        }
        if (type != 0) {
            this.addMethodInfo(sb, time);
        }
        return sb.toString();
    }

    private void addEvent(int level, String msg, Object[] params, Object printable, int type) {
        boolean isLogEnabled = level == 1 && this.logger.isTtraceEnabled() || level == 2 && this.logger.isDebugEnabled() || level == 3 && this.logger.isInfoEnabled() || level == 4 && this.logger.isWarnEnabled() || level == 5 && this.logger.isErrorEnabled() || level == 6 && this.logger.isFatalEnabled();
        long time = System.currentTimeMillis();
        if (isLogEnabled) {
            String message;
            msg = message = this.format(msg, params, printable, time, type);
            type = 0;
            if (level == 1) {
                this.logger.trace(message);
            } else if (level == 2) {
                this.logger.debug(message);
            } else if (level == 3) {
                this.logger.info(message);
            } else if (level == 4) {
                this.logger.warn(message);
            } else if (level == 5) {
                this.logger.error(message);
            } else if (level == 6) {
                this.logger.fatal(message);
            }
        }
        if (this.historyNotInitiated) {
            this.withHistory();
        }
        if (this.historyEnabled && this.history.size() < this.historySize) {
            Event e = new Event();
            e.level = level;
            e.msg = msg;
            e.params = params;
            e.time = time;
            e.type = type;
            e.printable = printable;
            this.history.add(e);
        }
    }

    private void methodInfo() {
        this.addEvent(1, null, this.params, new MethodInfo(), 4);
    }

    private String history() {
        StringBuilder sb = new StringBuilder();
        if (this.context()) {
            sb.append(">> --- thread context start -----------\n").append(this.contextString()).append("\n");
        }
        sb.append(">> --- method history start - ").append(this.methodName).append(" -----------\n");
        for (Event event : this.history) {
            sb.append(">> --- ").append(this.format(event.msg, event.params, event.printable, event.time, event.type)).append("\n");
        }
        sb.append(">> --- method history end  - ").append(this.methodName).append(" -----------");
        return sb.toString();
    }

    public void historyToInfo() {
        if (this.warn()) {
            this.logger.info(this.history());
        }
    }

    public void historyToWaen() {
        if (this.warn()) {
            this.logger.warn(this.history());
        }
    }

    public void historyToError() {
        if (this.error()) {
            this.logger.error(this.history());
        }
    }

    public void historyToFatal() {
        if (this.fatal()) {
            this.logger.fatal(this.history());
        }
    }

    public Jalw withHistory() {
        return this.withHistory(50);
    }

    public Jalw withHistory(int size) {
        this.historyNotInitiated = false;
        this.historyEnabled = true;
        this.historySize = size;
        if (this.history == null) {
            this.history = new ArrayList<Event>();
        }
        return this;
    }

    public Jalw withoutHistory() {
        this.historyNotInitiated = false;
        this.historyEnabled = false;
        return this;
    }

    public Jalw noMethodInfo() {
        this.noMethodInfo = true;
        return this;
    }

    public Jalw start(String methodName) {
        this.methodName = methodName;
        this.methodInfo();
        return this;
    }

    public Jalw start(String methodName, Object ... params) {
        this.methodName = methodName;
        this.params = params;
        this.methodInfo();
        return this;
    }

    public boolean trace() {
        return this.logger.isTtraceEnabled();
    }

    public Jalw trace(Object msg) {
        this.addEvent(1, null, null, msg, 4);
        return this;
    }

    public Jalw trace(Throwable t) {
        this.addEvent(1, null, null, new StackTrace(t, 0), 4);
        return this;
    }

    public Jalw trace(Throwable t, int limit) {
        this.addEvent(1, null, null, new StackTrace(t, limit), 4);
        return this;
    }

    public Jalw trace(String msg, Object ... params) {
        this.addEvent(1, msg, params, null, 2);
        return this;
    }

    public Jalw tracef(String msg, Object ... params) {
        this.addEvent(1, msg, params, null, 3);
        return this;
    }

    public boolean debug() {
        return this.logger.isDebugEnabled();
    }

    public Jalw debug(Object msg) {
        this.addEvent(2, null, null, msg, 4);
        return this;
    }

    public Jalw debug(Throwable t) {
        this.addEvent(2, null, null, new StackTrace(t, 0), 4);
        return this;
    }

    public Jalw debug(Throwable t, int limit) {
        this.addEvent(2, null, null, new StackTrace(t, limit), 4);
        return this;
    }

    public Jalw debug(String msg, Object ... params) {
        this.addEvent(2, msg, params, null, 2);
        return this;
    }

    public Jalw debugf(String msg, Object ... params) {
        this.addEvent(2, msg, params, null, 3);
        return this;
    }

    public boolean info() {
        return this.logger.isInfoEnabled();
    }

    public Jalw info(Object msg) {
        this.addEvent(3, null, null, msg, 4);
        return this;
    }

    public Jalw info(Throwable t) {
        this.addEvent(3, null, null, new StackTrace(t, 0), 4);
        return this;
    }

    public Jalw info(Throwable t, int limit) {
        this.addEvent(3, null, null, new StackTrace(t, limit), 4);
        return this;
    }

    public Jalw info(String msg, Object ... params) {
        this.addEvent(3, msg, params, null, 2);
        return this;
    }

    public Jalw infof(String msg, Object ... params) {
        this.addEvent(3, msg, params, null, 3);
        return this;
    }

    public boolean warn() {
        return this.logger.isWarnEnabled();
    }

    public Jalw warn(Object msg) {
        this.addEvent(4, null, null, msg, 4);
        return this;
    }

    public Jalw warn(Throwable t) {
        this.addEvent(4, null, null, new StackTrace(t, 0), 4);
        return this;
    }

    public Jalw warn(Throwable t, int limit) {
        this.addEvent(4, null, null, new StackTrace(t, limit), 4);
        return this;
    }

    public Jalw warn(String msg, Object ... params) {
        this.addEvent(4, msg, params, null, 2);
        return this;
    }

    public Jalw warnf(String msg, Object ... params) {
        this.addEvent(4, msg, params, null, 3);
        return this;
    }

    public boolean error() {
        return this.logger.isErrorEnabled();
    }

    public Jalw error(Object msg) {
        this.addEvent(5, null, null, msg, 4);
        return this;
    }

    public Jalw error(Throwable t) {
        this.addEvent(5, null, null, new StackTrace(t, 0), 4);
        return this;
    }

    public Jalw error(Throwable t, int limit) {
        this.addEvent(5, null, null, new StackTrace(t, limit), 4);
        return this;
    }

    public Jalw error(String msg, Object ... params) {
        this.addEvent(5, msg, params, null, 2);
        return this;
    }

    public Jalw errorf(String msg, Object ... params) {
        this.addEvent(5, msg, params, null, 3);
        return this;
    }

    public boolean fatal() {
        return this.logger.isFatalEnabled();
    }

    public Jalw fatal(Object msg) {
        this.addEvent(6, null, null, msg, 4);
        return this;
    }

    public Jalw fatal(Throwable t) {
        this.addEvent(6, null, null, new StackTrace(t, 0), 4);
        return this;
    }

    public Jalw fatal(Throwable t, int limit) {
        this.addEvent(6, null, null, new StackTrace(t, limit), 4);
        return this;
    }

    public Jalw fatal(String msg, Object ... params) {
        this.addEvent(6, msg, params, null, 2);
        return this;
    }

    public Jalw fatalf(String msg, Object ... params) {
        this.addEvent(6, msg, params, null, 3);
        return this;
    }

    public Jalw contextClean() {
        ThreadCtx.clean();
        return this;
    }

    public Jalw contextClean(int max) {
        ThreadCtx.clean(max);
        return this;
    }

    public boolean context() {
        return !ThreadCtx.isEmpty();
    }

    public String contextString() {
        return ThreadCtx.string();
    }

    public List<String> contextList() {
        return ThreadCtx.list();
    }

    public Jalw context(String value) {
        ThreadCtx.add(value);
        return this;
    }

    public Jalw context(String value, Object ... params) {
        ThreadCtx.add(this.format(value, params));
        return this;
    }

    public Jalw contextf(String value, Object ... params) {
        ThreadCtx.add(this.formatf(value, params));
        return this;
    }

    public Jalw end() {
        String msg = "<- " + this.methodName;
        this.addEvent(1, msg, null, null, 1);
        return this;
    }

    public Jalw end(Object msg) {
        String msg2 = "<- " + this.methodName + " [{}]";
        this.addEvent(1, msg2, new Object[]{msg}, null, 2);
        return this;
    }

    public Jalw end(Throwable t) {
        String msg = "<- " + this.methodName + " [" + t + "]";
        this.addEvent(1, null, null, msg, 4);
        return this;
    }

    public Jalw end(String msg, Object ... params) {
        msg = "<- " + this.methodName + " [" + msg + "]";
        this.addEvent(1, msg, params, null, 2);
        return this;
    }

    public Jalw endf(String msg, Object ... params) {
        msg = "<- " + this.methodName + " [" + msg + "]";
        this.addEvent(1, msg, params, null, 3);
        return this;
    }

    public Appender toTrace() {
        return new Appender(this, 1);
    }

    public Appender toDebug() {
        return new Appender(this, 2);
    }

    public Appender toInfo() {
        return new Appender(this, 3);
    }

    public Appender toWarn() {
        return new Appender(this, 4);
    }

    public Appender toError() {
        return new Appender(this, 5);
    }

    public Appender toFatal() {
        return new Appender(this, 6);
    }

    public Checker check(boolean condition) {
        return new Checker(this, condition);
    }

    public Checker checkNull(Object oblect) {
        return new Checker(this, oblect == null);
    }

    public static Show show() {
        return new Show();
    }

    public Checker checkEmpty(Object oblect) {
        boolean condition;
        boolean bl = condition = oblect == null;
        if (!condition && oblect instanceof String) {
            condition = "".equals(oblect);
        } else if (!condition && oblect instanceof Map) {
            condition = ((Map)oblect).isEmpty();
        } else if (!condition && oblect instanceof Collection) {
            condition = ((Collection)oblect).isEmpty();
        } else if (!condition && oblect instanceof int[]) {
            condition = ((int[])oblect).length == 0;
        } else if (!condition && oblect instanceof byte[]) {
            condition = ((byte[])oblect).length == 0;
        } else if (!condition && oblect instanceof Object[]) {
            condition = ((Object[])oblect).length == 0;
        }
        return new Checker(this, condition);
    }

    private class MethodInfo {
        private MethodInfo() {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(">- ").append(Jalw.this.methodName);
            if (Jalw.this.params != null) {
                for (Object param : Jalw.this.params) {
                    sb.append(" [").append(param).append("]");
                }
            }
            return sb.toString();
        }
    }

    private static class Event {
        public int level;
        public int type;
        long time = 0L;
        public String msg;
        public Object[] params;
        public Object printable;

        private Event() {
        }
    }
}

