/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.jalw.ctx;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadCtx {
    private static ThreadLocal<Data> instance = new ThreadLocal();

    public static void clean() {
        Data data = instance.get();
        if (data != null) {
            data.clean(20);
        } else {
            instance.set(new Data(20));
        }
    }

    public static void clean(int max) {
        Data data = instance.get();
        if (data != null) {
            data.clean(max);
        } else {
            instance.set(new Data(max));
        }
    }

    public static void add(String value) {
        Data data = instance.get();
        if (data == null) {
            data = new Data(20);
            instance.set(data);
        }
        data.add(value);
    }

    public static List<String> list() {
        Data data = instance.get();
        if (data == null) {
            data = new Data(20);
            instance.set(data);
        }
        return data.list();
    }

    public static String string() {
        Data data = instance.get();
        if (data == null) {
            data = new Data(20);
            instance.set(data);
        }
        return data.toString();
    }

    public static boolean isEmpty() {
        Data data = instance.get();
        if (data == null) {
            return true;
        }
        return data.isEmpty();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Data {
        private int max = 20;
        private List<String> values = null;

        public Data(int max) {
            this.max = max;
            this.values = new ArrayList<String>(max);
        }

        public void clean() {
            this.values.clear();
        }

        public void clean(int max) {
            this.values.clear();
            this.max = max;
        }

        public void add(String value) {
            if (this.values.size() > this.max) {
                return;
            }
            this.values.add(value);
        }

        public List<String> list() {
            return Collections.unmodifiableList(this.values);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Thread Context [\n");
            for (String value : this.values) {
                sb.append("  - [").append(value).append("]\n");
            }
            sb.append("]");
            return sb.toString();
        }

        public boolean isEmpty() {
            return this.values.isEmpty();
        }
    }
}

