/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.jaul.pojo;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import sk.antons.jaul.binary.Base64;
import sk.antons.jaul.pojo.ToJsonString;

public class JsonString {
    private boolean ignoreNulls = true;
    private String indent = null;
    private StringBuilder sb = new StringBuilder();
    Deque<State> stack = new LinkedList<State>();

    public static JsonString instance() {
        return new JsonString();
    }

    public JsonString ignoreNulls(boolean value) {
        this.ignoreNulls = value;
        return this;
    }

    public JsonString indent(String indent) {
        this.indent = indent;
        return this;
    }

    public String toString() {
        return this.sb.toString();
    }

    public JsonString objectStart() {
        if (this.indent == null) {
            this.sb.append('{');
        } else {
            this.sb.append("{");
        }
        this.something();
        this.stack.push(State.instance(Type.OBJECT));
        return this;
    }

    public JsonString objectEnd() {
        if (this.indent != null && this.isSomething()) {
            this.sb.append('\n');
            this.indent(-1);
        }
        this.sb.append('}');
        this.stack.pop();
        return this;
    }

    public JsonString arrayStart() {
        this.sb.append('[');
        this.something();
        this.stack.push(State.instance(Type.ARRAY));
        return this;
    }

    public JsonString arrayEnd() {
        this.sb.append(']');
        this.stack.pop();
        return this;
    }

    public JsonString value(Object value) {
        if (this.isArray() && this.isSomething()) {
            this.sb.append(',');
            if (this.indent != null) {
                this.sb.append(' ');
            }
        }
        this.appendValue(value);
        this.something();
        return this;
    }

    public JsonString attrName(String name) {
        if (this.isSomething()) {
            this.sb.append(',');
        }
        if (this.indent != null) {
            this.sb.append('\n');
            this.indent();
        }
        this.sb.append('\"').append(name).append('\"');
        if (this.indent != null) {
            this.sb.append(" : ");
        } else {
            this.sb.append(":");
        }
        this.something();
        return this;
    }

    public JsonString attr(String name, Object value) {
        if (this.ignoreNulls && value == null) {
            return this;
        }
        this.attrName(name);
        this.value(value);
        return this;
    }

    private void appendValue(Object o) {
        if (o == null) {
            this.sb.append("null");
            return;
        }
        Class<?> clazz = o.getClass();
        if (this.isNonStringClass(clazz)) {
            this.sb.append(o);
            return;
        }
        if (clazz.isArray()) {
            Class<?> clazzin = clazz.getComponentType();
            if (clazzin.equals(Byte.TYPE)) {
                byte[] bytes = (byte[])o;
                String ss = Base64.encode(bytes);
                this.sb.append('\"').append(ss).append('\"');
                return;
            }
            this.arrayStart();
            int size = ((Object[])o).length;
            for (int i = 0; i < size; ++i) {
                this.value(Array.get(o, i));
            }
            this.arrayEnd();
            return;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            Collection coll = (Collection)o;
            this.arrayStart();
            for (Object next : coll) {
                this.value(next);
            }
            this.arrayEnd();
            return;
        }
        if (ToJsonString.class.isAssignableFrom(clazz)) {
            ToJsonString jsso = (ToJsonString)o;
            jsso.toJsonString(this, true);
            return;
        }
        this.sb.append('\"').append(JsonString.escape(o.toString())).append('\"');
    }

    private boolean isNonStringClass(Class clazz) {
        if (clazz.equals(Integer.TYPE)) {
            return true;
        }
        if (clazz.equals(Long.TYPE)) {
            return true;
        }
        if (clazz.equals(Byte.TYPE)) {
            return true;
        }
        if (clazz.equals(Short.TYPE)) {
            return true;
        }
        if (clazz.equals(Double.TYPE)) {
            return true;
        }
        if (clazz.equals(Float.TYPE)) {
            return true;
        }
        if (clazz.equals(Boolean.TYPE)) {
            return true;
        }
        if (clazz.equals(Character.TYPE)) {
            return true;
        }
        if (clazz.equals(Integer.class)) {
            return true;
        }
        if (clazz.equals(Long.class)) {
            return true;
        }
        if (clazz.equals(Byte.class)) {
            return true;
        }
        if (clazz.equals(Short.class)) {
            return true;
        }
        if (clazz.equals(Double.class)) {
            return true;
        }
        if (clazz.equals(Float.class)) {
            return true;
        }
        if (clazz.equals(Boolean.class)) {
            return true;
        }
        return clazz.equals(Character.class);
    }

    private boolean isArray() {
        if (this.stack.isEmpty()) {
            return false;
        }
        return this.stack.peek().type == Type.ARRAY;
    }

    private boolean isObject() {
        if (this.stack.isEmpty()) {
            return false;
        }
        return this.stack.peek().type == Type.OBJECT;
    }

    private void something() {
        if (this.stack.isEmpty()) {
            return;
        }
        this.stack.peek().something = true;
    }

    private boolean isSomething() {
        if (this.stack.isEmpty()) {
            return false;
        }
        return this.stack.peek().something;
    }

    private void indent() {
        this.indent(0);
    }

    private void indent(int correction) {
        int sum = this.stack.size() + correction;
        for (int i = 0; i < sum; ++i) {
            this.sb.append(this.indent);
        }
    }

    private static String escape(String value) {
        if (value == null) {
            return null;
        }
        int offset = 0;
        int length = value.length();
        StringBuilder sb = new StringBuilder();
        int len = offset + length;
        for (int i = offset; i < len; ++i) {
            char c = value.charAt(i);
            if (c == '\"') {
                sb.append("\\\"");
                continue;
            }
            if (c == '\\') {
                sb.append("\\\\");
                continue;
            }
            if (c == '\n') {
                sb.append("\\n");
                continue;
            }
            if (c == '\t') {
                sb.append("\\t");
                continue;
            }
            if (c == '\r') {
                sb.append("\\r");
                continue;
            }
            if (c == '/') {
                sb.append("\\/");
                continue;
            }
            if (c == '\b') {
                sb.append("\\b");
                continue;
            }
            if (c == '\f') {
                sb.append("\\f");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static class State {
        public Type type;
        public boolean something = false;

        private State() {
        }

        public static State instance(Type type) {
            State s = new State();
            s.type = type;
            return s;
        }
    }

    private static enum Type {
        ARRAY,
        OBJECT;

    }
}

