/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.jaul.util;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import sk.antons.jaul.Is;
import sk.antons.jaul.binary.Bytes;

public class BinFile {
    public static InputStream read(String filename) {
        if (Is.empty(filename)) {
            return null;
        }
        try {
            return new FileInputStream(filename);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to read file '" + filename + "'", e);
        }
    }

    public static byte[] readBytes(String filename) {
        if (Is.empty(filename)) {
            return new byte[0];
        }
        return Bytes.fromStream(BinFile.read(filename));
    }

    public static int save(String filename, InputStream is) {
        if (Is.empty(filename)) {
            return 0;
        }
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            int rv = 0;
            if (!Is.empty(is)) {
                rv = Bytes.transfer(is, fos);
            }
            fos.flush();
            fos.close();
            return rv;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to save file '" + filename + "'", e);
        }
    }

    public static int save(String filename, byte[] bytes) {
        if (Is.empty(filename)) {
            return 0;
        }
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            int rv = 0;
            if (!Is.empty((Object)bytes)) {
                rv = bytes.length;
                fos.write(bytes);
            }
            fos.flush();
            fos.close();
            return rv;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to save file '" + filename + "'", e);
        }
    }
}

