/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.jaul.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class TextFileSplitter {
    private final BufferedReader reader;
    boolean closereader = true;

    public TextFileSplitter(String filename, String charset) {
        try {
            this.reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), charset));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to read file '" + filename + "' with charset '" + charset + "'", e);
        }
    }

    public TextFileSplitter(File file, String charset) {
        try {
            this.reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charset));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to read file '" + file + "' with charset '" + charset + "'", e);
        }
    }

    public TextFileSplitter(InputStream is, String charset) {
        try {
            this.reader = new BufferedReader(new InputStreamReader(is, charset));
            this.closereader = false;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to read is with charset '" + charset + "'", e);
        }
    }

    public Iterator<String> byLines() {
        if (this.reader == null) {
            return new EmptyIterator();
        }
        return new LineIterator();
    }

    public List<String> byLinesToList() {
        return TextFileSplitter.toList(this.byLines());
    }

    private static List<String> toList(Iterator<String> iterator) {
        ArrayList<String> rv = new ArrayList<String>();
        while (iterator.hasNext()) {
            String next = iterator.next();
            rv.add(next);
        }
        return rv;
    }

    private class LineIterator
    implements Iterator<String> {
        private String line = null;

        public LineIterator() {
            this.nextLine(true);
        }

        private void nextLine(boolean firstLine) {
            if (!firstLine && this.line == null) {
                return;
            }
            this.line = null;
            try {
                this.line = TextFileSplitter.this.reader.readLine();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to read next line", e);
            }
            if (this.line == null && TextFileSplitter.this.closereader) {
                try {
                    TextFileSplitter.this.reader.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.line != null;
        }

        @Override
        public String next() {
            if (this.line == null) {
                throw new NoSuchElementException("No moere elements");
            }
            String rv = this.line;
            this.nextLine(false);
            return rv;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class EmptyIterator
    implements Iterator<String> {
        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public String next() {
            throw new NoSuchElementException("Empty iterator");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

