/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.jaul.xml;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EW {
    private Element element;
    private List<Attr> attributes = null;

    private List<Attr> attributes() {
        if (this.attributes == null) {
            this.attributes = new ArrayList<Attr>();
            NamedNodeMap map = this.element.getAttributes();
            for (int i = 0; i < map.getLength(); ++i) {
                Node n = map.item(i);
                Attr a = new Attr(n.getNodeName());
                a.value = n.getTextContent();
                this.attributes.add(a);
            }
        }
        return this.attributes;
    }

    private EW(Element element) {
        if (element == null) {
            throw new IllegalArgumentException("Unable to create EW from null element.");
        }
        this.element = element;
    }

    public static EW elem(Element element) {
        return new EW(element);
    }

    public Element elem() {
        return this.element;
    }

    private String attr(String ns, String name) {
        if (name == null) {
            return null;
        }
        for (Attr a : this.attributes()) {
            if (ns != null && !ns.equals(a.ns) || name != null && !name.equals(a.fullname) && !name.equals(a.name)) continue;
            return a.value;
        }
        return null;
    }

    public String attr(String name) {
        return this.attr(null, name);
    }

    public String attrNS(String ns, String name) {
        return this.attr(ns, name);
    }

    public String text() {
        if (this.element == null) {
            return null;
        }
        return this.element.getTextContent();
    }

    public EW parent() {
        for (Node node = this.element.getParentNode(); node != null; node = node.getParentNode()) {
            if (!(node instanceof Element)) continue;
            return EW.elem((Element)node);
        }
        return null;
    }

    private static List<EW> toList(NodeList nl, String ns, String tag) {
        ArrayList<EW> list = new ArrayList<EW>();
        if (nl != null) {
            if (ns != null) {
                ns = ns + ":";
            }
            String tag2 = null;
            if (tag != null) {
                tag2 = ":" + tag;
            }
            for (int i = 0; i < nl.getLength(); ++i) {
                Node n = nl.item(i);
                if (n == null || !(n instanceof Element)) continue;
                String fullname = n.getNodeName();
                if (ns != null && !fullname.startsWith(ns) || tag != null && !tag.equals(fullname) && !fullname.endsWith(tag2)) continue;
                list.add(EW.elem((Element)n));
            }
        }
        return list;
    }

    private static List<EW> traverse(Element e, String ns, String tag) {
        NodeList nl;
        ArrayList<EW> list = new ArrayList<EW>();
        if (ns != null) {
            ns = ns + ":";
        }
        String tag2 = null;
        if (tag != null) {
            tag2 = ":" + tag;
        }
        if ((nl = e.getChildNodes()) != null) {
            for (int i = 0; i < nl.getLength(); ++i) {
                Node n = nl.item(i);
                if (n == null || !(n instanceof Element)) continue;
                EW.traverse(list, (Element)n, ns, tag, tag2);
            }
        }
        return list;
    }

    private static void traverse(List<EW> list, Element e, String ns, String tag, String tag2) {
        NodeList nl;
        if (e == null) {
            return;
        }
        String fullname = e.getNodeName();
        if ((ns == null || fullname.startsWith(ns)) && (tag == null || tag.equals(fullname) || fullname.endsWith(tag2))) {
            list.add(EW.elem(e));
        }
        if ((nl = e.getChildNodes()) != null) {
            for (int i = 0; i < nl.getLength(); ++i) {
                Node n = nl.item(i);
                if (n == null || !(n instanceof Element)) continue;
                EW.traverse(list, (Element)n, ns, tag, tag2);
            }
        }
    }

    private static EW toFirst(NodeList nl, String ns, String tag) {
        if (nl != null) {
            if (ns != null) {
                ns = ns + ":";
            }
            String tag2 = null;
            if (tag != null) {
                tag2 = ":" + tag;
            }
            for (int i = 0; i < nl.getLength(); ++i) {
                Node n = nl.item(i);
                if (n == null || !(n instanceof Element)) continue;
                String fullname = n.getNodeName();
                if (ns != null && !fullname.startsWith(ns) || tag != null && !tag.equals(fullname) && !fullname.endsWith(tag2)) continue;
                return EW.elem((Element)n);
            }
        }
        return null;
    }

    private static EW traverseFirst(Element e, String ns, String tag) {
        NodeList nl;
        if (ns != null) {
            ns = ns + ":";
        }
        String tag2 = null;
        if (tag != null) {
            tag2 = ":" + tag;
        }
        if ((nl = e.getChildNodes()) != null) {
            for (int i = 0; i < nl.getLength(); ++i) {
                EW ew;
                Node n = nl.item(i);
                if (n == null || !(n instanceof Element) || (ew = EW.traverseFirst((Element)n, ns, tag, tag2)) == null) continue;
                return ew;
            }
        }
        return null;
    }

    private static EW traverseFirst(Element e, String ns, String tag, String tag2) {
        if (e == null) {
            return null;
        }
        String fullname = e.getNodeName();
        if ((ns == null || fullname.startsWith(ns)) && (tag == null || tag.equals(fullname) || fullname.endsWith(tag2))) {
            return EW.elem(e);
        }
        NodeList nl = e.getChildNodes();
        if (nl != null) {
            for (int i = 0; i < nl.getLength(); ++i) {
                EW ew;
                Node n = nl.item(i);
                if (n == null || !(n instanceof Element) || (ew = EW.traverseFirst((Element)n, ns, tag, tag2)) == null) continue;
                return ew;
            }
        }
        return null;
    }

    public List<EW> children() {
        return EW.toList(this.element.getChildNodes(), null, null);
    }

    public List<EW> childrenByTagName(String tag) {
        return EW.toList(this.element.getChildNodes(), null, tag);
    }

    public List<EW> childrenByTagNameNS(String ns, String tag) {
        return EW.toList(this.element.getChildNodes(), ns, tag);
    }

    public List<EW> elementsByTagName(String tag) {
        return EW.traverse(this.element, null, tag);
    }

    public List<EW> elementsByTagNameNS(String ns, String tag) {
        return EW.traverse(this.element, ns, tag);
    }

    public EW firstChild() {
        return EW.toFirst(this.element.getChildNodes(), null, null);
    }

    public EW firstChildByTagName(String tag) {
        return EW.toFirst(this.element.getChildNodes(), null, tag);
    }

    public EW firstChildByTagNameNS(String ns, String tag) {
        return EW.toFirst(this.element.getChildNodes(), ns, tag);
    }

    public EW firstElementByTagName(String tag) {
        return EW.traverseFirst(this.element, null, tag);
    }

    public EW firstElementByTagNameNS(String ns, String tag) {
        return EW.traverseFirst(this.element, ns, tag);
    }

    public String tag() {
        String value = this.element.getNodeName();
        int pos = value.lastIndexOf(":");
        if (pos > -1) {
            return value.substring(pos + 1);
        }
        return value;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<").append(this.element.getNodeName());
        for (Attr attribute : this.attributes()) {
            sb.append(" ").append(attribute.fullname).append("=\"").append(attribute.value).append("\"");
        }
        sb.append(">");
        return sb.toString();
    }

    public List<String> attrNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (Attr attribute : this.attributes()) {
            names.add(attribute.fullname);
        }
        return names;
    }

    public String firstChildByTagNameTextContent(String tag) {
        EW ew = this.firstChildByTagName(tag);
        if (ew == null) {
            return null;
        }
        return ew.elem().getTextContent();
    }

    public String firstChildByTagNameNSTextContent(String ns, String tag) {
        EW ew = this.firstChildByTagNameNS(ns, tag);
        if (ew == null) {
            return null;
        }
        return ew.elem().getTextContent();
    }

    private static class Attr {
        private String fullname;
        private String name;
        private String ns;
        private String value;

        public Attr(String fullname) {
            if (fullname == null) {
                throw new IllegalArgumentException("Unable to create attribute with null name");
            }
            this.fullname = fullname;
            int pos = fullname.lastIndexOf(":");
            if (pos > -1) {
                this.ns = fullname.substring(0, pos);
                this.name = fullname.substring(pos + 1);
            } else {
                this.name = fullname;
            }
        }
    }
}

