/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.jaul.binary;

import sk.antons.jaul.Is;

public class Unicode {
    public static String escape(String input, boolean ignoreInvisible) {
        if (Is.empty(input)) {
            return input;
        }
        StringBuilder sb = new StringBuilder(input.length() + 30);
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if ((ignoreInvisible || c > '\u001f') && c < '\u007f') {
                sb.append(c);
                continue;
            }
            sb.append("\\u");
            String hex = Integer.toHexString(c);
            for (int j = hex.length(); j < 4; ++j) {
                sb.append('0');
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    public static String unescape(String input) {
        if (Is.empty(input)) {
            return input;
        }
        StringBuilder sb = new StringBuilder(input.length());
        boolean isbs = false;
        for (int i = 0; i < input.length(); ++i) {
            int c = input.charAt(i);
            if (isbs) {
                isbs = false;
                if (c == 102) {
                    c = 12;
                } else if (c == 110) {
                    c = 10;
                } else if (c == 114) {
                    c = 13;
                } else if (c == 116) {
                    c = 9;
                } else if (c == 92) {
                    c = 92;
                } else if (c == 117) {
                    String hex = input.substring(i + 1, i + 5);
                    c = (char)Integer.parseInt(hex, 16);
                    i += 4;
                } else {
                    sb.append('\\');
                }
            } else {
                boolean bl = isbs = c == 92;
            }
            if (isbs) continue;
            sb.append((char)c);
        }
        return sb.toString();
    }

    public static String escapeJava(String input) {
        if (Is.empty(input)) {
            return input;
        }
        StringBuilder sb = new StringBuilder(input.length() + 30);
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '\b') {
                sb.append("\\b");
                continue;
            }
            if (c == '\n') {
                sb.append("\\n");
                continue;
            }
            if (c == '\r') {
                sb.append("\\r");
                continue;
            }
            if (c == '\t') {
                sb.append("\\t");
                continue;
            }
            if (c == '\f') {
                sb.append("\\f");
                continue;
            }
            if (c == '\'') {
                sb.append("\\'");
                continue;
            }
            if (c == '\\') {
                sb.append("\\\\");
                continue;
            }
            if (c == '\"') {
                sb.append("\\\"");
                continue;
            }
            if (c > '\u001f' && c < '\u007f') {
                sb.append(c);
                continue;
            }
            sb.append("\\u");
            String hex = Integer.toHexString(c);
            for (int j = hex.length(); j < 4; ++j) {
                sb.append('0');
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    public static String unescapeJava(String input) {
        if (Is.empty(input)) {
            return input;
        }
        StringBuilder sb = new StringBuilder(input.length());
        boolean isbs = false;
        for (int i = 0; i < input.length(); ++i) {
            int c = input.charAt(i);
            if (isbs) {
                isbs = false;
                if (c == 102) {
                    c = 12;
                } else if (c == 110) {
                    c = 10;
                } else if (c == 114) {
                    c = 13;
                } else if (c == 116) {
                    c = 9;
                } else if (c == 98) {
                    c = 8;
                } else if (c == 92) {
                    c = 92;
                } else if (c == 34) {
                    c = 34;
                } else if (c == 39) {
                    c = 39;
                } else if (c == 117) {
                    String hex = input.substring(i + 1, i + 5);
                    c = (char)Integer.parseInt(hex, 16);
                    i += 4;
                } else {
                    sb.append('\\');
                }
            } else {
                boolean bl = isbs = c == 92;
            }
            if (isbs) continue;
            sb.append((char)c);
        }
        return sb.toString();
    }

    public static String escapeHtml(String input, boolean ignoreInvisible) {
        if (Is.empty(input)) {
            return input;
        }
        StringBuilder buff = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if ((ignoreInvisible || c > '\u001f') && c < '\u007f') {
                buff.append(c);
                continue;
            }
            buff.append("&#").append((int)c).append(';');
        }
        return buff.toString();
    }

    public static String unescapeHtml(String input) {
        if (Is.empty(input)) {
            return input;
        }
        StringBuilder buff = new StringBuilder();
        int state = 0;
        int sbuff = 0;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (state == 0) {
                if (c == '&') {
                    state = 1;
                    continue;
                }
            } else if (state == 1) {
                if (c == '#') {
                    state = 2;
                    sbuff = 0;
                    continue;
                }
                buff.append('&');
                state = 0;
            } else if (state == 2) {
                if ('0' <= c && c <= '9') {
                    state = 3;
                    sbuff = 10 * sbuff + (c - 48);
                    continue;
                }
                buff.append('&');
                buff.append('#');
                state = 0;
            } else if (state == 3) {
                if ('0' <= c && c <= '9') {
                    state = 3;
                    sbuff = 10 * sbuff + (c - 48);
                    continue;
                }
                if (c == ';') {
                    buff.append((char)sbuff);
                    state = 0;
                    continue;
                }
                buff.append('&');
                buff.append('#');
                buff.append(sbuff);
                state = 0;
            }
            buff.append(c);
        }
        return buff.toString();
    }
}

