/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.jaul.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import sk.antons.jaul.Is;

public class TextFile {
    public static String read(InputStream is, String charset) {
        if (is == null) {
            return null;
        }
        if (Is.empty(charset)) {
            charset = "utf-8";
        }
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, charset));
            StringBuilder sb = new StringBuilder();
            String line = reader.readLine();
            while (line != null) {
                if (sb.length() > 0) {
                    sb.append('\n');
                }
                sb.append(line);
                line = reader.readLine();
            }
            reader.close();
            return sb.toString();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to read file data with charset '" + charset + "'", e);
        }
    }

    public static String read(String filename, String charset) {
        if (Is.empty(filename)) {
            return null;
        }
        if (Is.empty(charset)) {
            charset = "utf-8";
        }
        try {
            return TextFile.read(new FileInputStream(filename), charset);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to read file '" + filename + "' with charset '" + charset + "'", e);
        }
    }

    public static void save(String filename, String charset, String text) {
        if (Is.empty(charset)) {
            charset = "utf-8";
        }
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), charset));
            if (text != null) {
                writer.write(text);
            }
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to save file '" + filename + "' with charset '" + charset + "'", e);
        }
    }
}

