/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.jaul.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import sk.antons.jaul.Is;
import sk.antons.jaul.util.TextFile;

public class Xml {
    public static Document document(InputStream stream) {
        if (stream == null) {
            return null;
        }
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(false);
            dbf.setNamespaceAware(true);
            dbf.setFeature("http://xml.org/sax/features/namespaces", false);
            dbf.setFeature("http://xml.org/sax/features/validation", false);
            dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource is = new InputSource(stream);
            return db.parse(is);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to parse xml document", e);
        }
    }

    public static Document document(String xml) {
        if (xml == null) {
            return null;
        }
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(false);
            dbf.setNamespaceAware(true);
            dbf.setFeature("http://xml.org/sax/features/namespaces", false);
            dbf.setFeature("http://xml.org/sax/features/validation", false);
            dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource is = new InputSource(new StringReader(xml));
            return db.parse(is);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to parse xml document", e);
        }
    }

    public static Document documentFromFile(String filename) {
        if (filename == null) {
            return null;
        }
        try {
            return Xml.document(new FileInputStream(filename));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to parse xml document from file " + filename, e);
        }
    }

    public static Document documentFromFile(File file) {
        if (file == null) {
            return null;
        }
        try {
            return Xml.document(new FileInputStream(file));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to parse xml document from file " + file, e);
        }
    }

    public static String escape(String value) {
        if (Is.empty(value)) {
            return value;
        }
        StringBuilder sb = new StringBuilder();
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c == '\"') {
                sb.append("&quot;");
                continue;
            }
            if (c == '\'') {
                sb.append("&apos;");
                continue;
            }
            if (c == '<') {
                sb.append("&lt;");
                continue;
            }
            if (c == '>') {
                sb.append("&gt;");
                continue;
            }
            if (c == '&') {
                sb.append("&amp;");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String unescape(String value) {
        if (Is.empty(value)) {
            return value;
        }
        StringBuilder sb = new StringBuilder();
        int len = value.length();
        int state = 0;
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c == '&') {
                state = 1;
                continue;
            }
            if (c == 'q' && state == 1) {
                state = 2;
                continue;
            }
            if (c == 'u' && state == 2) {
                state = 3;
                continue;
            }
            if (c == 'o' && state == 3) {
                state = 4;
                continue;
            }
            if (c == 't' && state == 4) {
                state = 5;
                continue;
            }
            if (c == 'l' && state == 1) {
                state = 6;
                continue;
            }
            if (c == 't' && state == 6) {
                state = 7;
                continue;
            }
            if (c == 'g' && state == 1) {
                state = 8;
                continue;
            }
            if (c == 't' && state == 8) {
                state = 9;
                continue;
            }
            if (c == 'a' && state == 1) {
                state = 10;
                continue;
            }
            if (c == 'p' && state == 10) {
                state = 11;
                continue;
            }
            if (c == 'o' && state == 11) {
                state = 12;
                continue;
            }
            if (c == 's' && state == 12) {
                state = 13;
                continue;
            }
            if (c == 'm' && state == 10) {
                state = 14;
                continue;
            }
            if (c == 'p' && state == 14) {
                state = 15;
                continue;
            }
            if (c == ';' && state == 15) {
                sb.append('&');
                state = 0;
                continue;
            }
            if (c == ';' && state == 13) {
                sb.append('\'');
                state = 0;
                continue;
            }
            if (c == ';' && state == 9) {
                sb.append('>');
                state = 0;
                continue;
            }
            if (c == ';' && state == 7) {
                sb.append('<');
                state = 0;
                continue;
            }
            if (c == ';' && state == 5) {
                sb.append('\"');
                state = 0;
                continue;
            }
            if (state == 1) {
                sb.append("&");
            } else if (state == 2) {
                sb.append("&q");
            } else if (state == 3) {
                sb.append("&qu");
            } else if (state == 4) {
                sb.append("&quo");
            } else if (state == 5) {
                sb.append("&quot");
            } else if (state == 6) {
                sb.append("&l");
            } else if (state == 7) {
                sb.append("&lt");
            } else if (state == 8) {
                sb.append("&g");
            } else if (state == 9) {
                sb.append("&gt");
            } else if (state == 10) {
                sb.append("&a");
            } else if (state == 11) {
                sb.append("&ap");
            } else if (state == 12) {
                sb.append("&apo");
            } else if (state == 13) {
                sb.append("&apos");
            } else if (state == 14) {
                sb.append("&am");
            } else if (state == 15) {
                sb.append("&amp");
            }
            state = 0;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String documentToString(Document doc, String encoding, boolean indent, boolean declaration) {
        if (doc == null) {
            return null;
        }
        try {
            StringWriter sw = new StringWriter();
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            if (declaration) {
                transformer.setOutputProperty("omit-xml-declaration", "no");
            } else {
                transformer.setOutputProperty("omit-xml-declaration", "yes");
            }
            if (encoding != null) {
                transformer.setOutputProperty("encoding", encoding);
            }
            if (indent) {
                transformer.setOutputProperty("indent", "yes");
            }
            transformer.setOutputProperty("method", "xml");
            transformer.transform(new DOMSource(doc), new StreamResult(sw));
            return sw.toString();
        }
        catch (Exception ex) {
            throw new IllegalStateException("Error converting to String", ex);
        }
    }

    public static String elementToString(Element element, String encoding, boolean indent, boolean declaration) {
        if (element == null) {
            return null;
        }
        try {
            StringWriter sw = new StringWriter();
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            if (declaration) {
                transformer.setOutputProperty("omit-xml-declaration", "no");
            } else {
                transformer.setOutputProperty("omit-xml-declaration", "yes");
            }
            if (encoding != null) {
                transformer.setOutputProperty("encoding", encoding);
            }
            if (indent) {
                transformer.setOutputProperty("indent", "yes");
            }
            transformer.setOutputProperty("method", "xml");
            transformer.transform(new DOMSource(element), new StreamResult(sw));
            return sw.toString();
        }
        catch (Exception ex) {
            throw new IllegalStateException("Error converting to String", ex);
        }
    }

    public static void documentToFile(Document doc, File file, String encoding, boolean indent, boolean declaration) {
        if (doc == null) {
            return;
        }
        try {
            if (encoding == null) {
                encoding = "UTF-8";
            }
            String xml = Xml.documentToString(doc, encoding, indent, declaration);
            TextFile.save(file.getAbsolutePath(), encoding, xml);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Error converting to String of save to file ", ex);
        }
    }

    public static void documentToFile(Document doc, String file, String encoding, boolean indent, boolean declaration) {
        if (doc == null) {
            return;
        }
        try {
            if (encoding == null) {
                encoding = "UTF-8";
            }
            String xml = Xml.documentToString(doc, encoding, indent, declaration);
            TextFile.save(file, encoding, xml);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Error converting to String of save to file ", ex);
        }
    }

    public static void trimWhiteSpaces(Node node) {
        if (node == null) {
            return;
        }
        if (node.getNodeType() != 1) {
            return;
        }
        NodeList children = node.getChildNodes();
        if (children == null) {
            return;
        }
        if (children.getLength() < 1) {
            return;
        }
        if (children.getLength() < 2 && children.item(0).getNodeType() == 3) {
            return;
        }
        for (int i = children.getLength() - 1; i >= 0; --i) {
            Node child = children.item(i);
            if (child.getNodeType() == 3) {
                String text = child.getTextContent();
                if (!Is.empty(text)) {
                    text = text.trim();
                }
                if (!Is.empty(text)) continue;
                node.removeChild(child);
                continue;
            }
            Xml.trimWhiteSpaces(child);
        }
    }
}

