/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.jaul.xml;

import sk.antons.jaul.Is;
import sk.antons.jaul.util.TextFile;

public class XmlFormat {
    private Source source = null;
    private StringBuilder newxml = null;
    private boolean oneline = true;
    private boolean forceoneline = false;
    private String indent = "  ";
    private int length;
    private boolean cut = false;
    private int cutLength = 1;

    public XmlFormat(String xml, int treshhold) {
        if (xml != null) {
            this.length = xml.length();
        }
        this.source = treshhold >= this.length ? CharsSource.instance(xml) : StringSource.instance(xml);
    }

    public static XmlFormat instance(String xml, int treshhold) {
        return new XmlFormat(xml, treshhold);
    }

    public XmlFormat indent(String indent) {
        this.indent = indent;
        this.oneline = false;
        return this;
    }

    public XmlFormat forceoneline() {
        this.forceoneline = true;
        return this;
    }

    public XmlFormat cutStringLiterals(int length) {
        if (length < 4) {
            length = 4;
        }
        this.cut = true;
        this.cutLength = length;
        return this;
    }

    public String format() {
        if (this.source.isEmpty()) {
            return this.source.original();
        }
        this.newxml = this.oneline ? new StringBuilder(this.length + this.length / 2) : new StringBuilder(this.length);
        int index = 0;
        int depth = 0;
        Token prevprevtoken = null;
        Token prevtoken = null;
        Position position = new Position();
        position.reset();
        this.next(index, position);
        while (position.token != null) {
            int pos = -1;
            switch (position.token) {
                case LEFT: {
                    if (position.nonspacecharacters) {
                        this.append(index, position.index);
                    } else if (!this.oneline) {
                        this.appendIndent(depth);
                    }
                    this.append(Token.LEFT);
                    ++depth;
                    break;
                }
                case RIGHT: {
                    this.appendTag(index, position.index);
                    this.append(Token.RIGHT);
                    break;
                }
                case LEFT_END: {
                    --depth;
                    if (prevprevtoken == Token.LEFT && prevtoken == Token.RIGHT || prevtoken == Token.CDATA_RIGHT) {
                        this.append(index, position.index);
                    } else if (position.nonspacecharacters) {
                        this.append(index, position.index);
                    } else if (!this.oneline) {
                        this.appendIndent(depth);
                    }
                    this.append(Token.LEFT_END);
                    break;
                }
                case RIGHT_SINGLE: {
                    --depth;
                    this.appendTag(index, position.index);
                    this.append(Token.RIGHT_SINGLE);
                    break;
                }
                case CDATA_LEFT: {
                    this.append(index, position.index);
                    pos = this.find(position.index, Token.CDATA_RIGHT);
                    this.append(Token.CDATA_LEFT);
                    if (pos > -1) {
                        this.append(position.index + Token.CDATA_LEFT.size(), pos);
                        this.append(Token.CDATA_RIGHT);
                        position.index = pos;
                        position.token = Token.CDATA_RIGHT;
                        break;
                    }
                    this.append(position.index + Token.CDATA_LEFT.size(), this.length);
                    position.index = this.length;
                    position.token = Token.CDATA_RIGHT;
                    this.append(index);
                    break;
                }
                case CDATA_RIGHT: {
                    this.append(index, position.index);
                    this.append(Token.CDATA_RIGHT);
                    break;
                }
                case COMMENT_LEFT: {
                    this.append(index, position.index);
                    pos = this.find(position.index, Token.COMMENT_RIGHT);
                    this.append(Token.COMMENT_LEFT);
                    if (pos > -1) {
                        this.append(position.index + Token.COMMENT_LEFT.size(), pos);
                        this.append(Token.COMMENT_RIGHT);
                        position.index = pos;
                        position.token = Token.COMMENT_RIGHT;
                        break;
                    }
                    this.append(position.index + Token.COMMENT_LEFT.size(), this.length);
                    position.index = this.length;
                    position.token = Token.COMMENT_RIGHT;
                    this.append(index);
                    break;
                }
                case COMMENT_RIGHT: {
                    this.append(index, position.index);
                    this.append(Token.COMMENT_RIGHT);
                    break;
                }
                case PROLOG_LEFT: {
                    this.append(Token.PROLOG_LEFT);
                    break;
                }
                case PROLOG_RIGHT: {
                    this.appendTag(index, position.index);
                    this.append(Token.PROLOG_RIGHT);
                    break;
                }
            }
            prevprevtoken = prevtoken;
            prevtoken = position.token;
            index = position.index + prevtoken.size();
            position.reset();
            this.next(index, position);
        }
        this.append(index);
        return this.newxml.toString();
    }

    private int find(int index, Token token) {
        return this.source.indexOf(token, index);
    }

    private void next(int index, Position position) {
        for (int i = index; i < this.length; ++i) {
            char c = this.source.charAt(i);
            block0 : switch (c) {
                case '<': {
                    if (i + 1 < this.length) {
                        char cc = this.source.charAt(i + 1);
                        switch (cc) {
                            case '/': {
                                position.token = Token.LEFT_END;
                                break;
                            }
                            case '!': {
                                if (this.source.match(Token.COMMENT_LEFT, i)) {
                                    position.token = Token.COMMENT_LEFT;
                                    break;
                                }
                                if (!this.source.match(Token.CDATA_LEFT, i)) break block0;
                                position.token = Token.CDATA_LEFT;
                                break;
                            }
                            case '?': {
                                position.token = Token.PROLOG_LEFT;
                                break;
                            }
                            default: {
                                position.token = Token.LEFT;
                                break;
                            }
                        }
                        break;
                    }
                    position.token = Token.LEFT;
                    break;
                }
                case '>': {
                    position.token = Token.RIGHT;
                    break;
                }
                case '-': {
                    if (!this.source.match(Token.COMMENT_RIGHT, i)) break;
                    position.token = Token.COMMENT_RIGHT;
                    break;
                }
                case '/': {
                    if (!this.source.match(Token.RIGHT_SINGLE, i)) break;
                    position.token = Token.RIGHT_SINGLE;
                    break;
                }
                case ']': {
                    if (!this.source.match(Token.CDATA_RIGHT, i)) break;
                    position.token = Token.CDATA_RIGHT;
                    break;
                }
                case '?': {
                    if (!this.source.match(Token.PROLOG_RIGHT, i)) break;
                    position.token = Token.PROLOG_RIGHT;
                    break;
                }
            }
            if (position.token != null) {
                position.index = i;
                return;
            }
            position.nonspacecharacters = position.nonspacecharacters || c != ' ' && c != '\n' && c != '\t' && c != '\r';
        }
    }

    private void appendTag(int from, int to) {
        char prev = '\u0000';
        char escape = '\u0000';
        for (int i = from; i < to; ++i) {
            char c = this.source.charAt(i);
            if (escape > '\u0000') {
                this.newxml.append(c);
                if (escape == c) {
                    escape = '\u0000';
                }
            } else if (c == '\'') {
                this.newxml.append(c);
                escape = c;
            } else if (c == '\"') {
                this.newxml.append(c);
                escape = c;
            } else {
                if (c == '\n' || c == '\t' || c == '\r') {
                    c = ' ';
                }
                if (c != ' ' || prev != ' ') {
                    this.newxml.append(c);
                }
            }
            prev = c;
        }
    }

    private void appendIndent(int depth) {
        if (this.newxml.length() > 0) {
            this.newxml.append('\n');
        }
        for (int i = 0; i < depth; ++i) {
            this.newxml.append(this.indent);
        }
    }

    private void append(int from, int to) {
        this.source.append(this.newxml, from, to, this.forceoneline, this.cut, this.cutLength);
    }

    private void append(int from) {
        this.source.append(this.newxml, from, this.forceoneline, this.cut, this.cutLength);
    }

    private void append(Token token) {
        this.newxml.append(token.pattern);
    }

    public static void main(String[] argv) {
        String xml = TextFile.read("/tmp/aaa/a.xml", "utf-8");
        int treshhold = 1000000;
        long timestart = System.currentTimeMillis();
        System.out.println(" ------------");
        System.out.println(XmlFormat.instance(xml, treshhold).forceoneline().cutStringLiterals(5).format());
        System.out.println(" ------------");
        System.out.println(XmlFormat.instance(xml, treshhold).indent("  ").cutStringLiterals(5).forceoneline().format());
        System.out.println(" ------------");
        System.out.println(XmlFormat.instance(XmlFormat.instance(xml, treshhold).forceoneline().format(), treshhold).indent("  ").forceoneline().format());
        System.out.println(" ------------");
        long timeend = System.currentTimeMillis();
        System.out.println(" time: " + (timeend - timestart));
    }

    private static class CharsSource
    implements Source {
        private String xml;
        private char[] chars;
        private int length;

        public CharsSource(String xml) {
            this.xml = xml;
            if (!Is.empty(xml)) {
                this.chars = xml.toCharArray();
                this.length = xml.length();
            }
        }

        public static CharsSource instance(String xml) {
            return new CharsSource(xml);
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        public char charAt(int index) {
            return this.chars[index];
        }

        @Override
        public boolean isEmpty() {
            return this.length == 0;
        }

        @Override
        public String original() {
            return this.xml;
        }

        @Override
        public int indexOf(Token token, int index) {
            int len = token.pattern.length;
            int len2 = this.length - len;
            for (int i = index; i < len2; ++i) {
                boolean found = true;
                for (int j = 0; j < len; ++j) {
                    if (this.chars[i + j] == token.pattern[j]) continue;
                    found = false;
                    break;
                }
                if (!found) continue;
                return i;
            }
            return -1;
        }

        @Override
        public boolean match(Token token, int index) {
            int len = token.pattern.length;
            if (len + index > this.length) {
                return false;
            }
            for (int j = 0; j < len; ++j) {
                if (this.chars[index + j] == token.pattern[j]) continue;
                return false;
            }
            return true;
        }

        @Override
        public void append(StringBuilder sb, int from, int to, boolean forceoneline, boolean cut, int cutLength) {
            int toto = to;
            boolean cutting = false;
            if (cut && from + cutLength < to) {
                toto = from + cutLength - 3;
                cutting = true;
            }
            if (forceoneline) {
                block4: for (int i = from; i < toto; ++i) {
                    char c = this.chars[i];
                    switch (c) {
                        case '\r': {
                            sb.append("&#13;");
                            continue block4;
                        }
                        case '\n': {
                            sb.append("&#10;");
                            continue block4;
                        }
                        default: {
                            sb.append(c);
                        }
                    }
                }
            } else {
                sb.append(this.chars, from, toto - from);
            }
            if (cutting) {
                sb.append("...");
            }
        }

        @Override
        public void append(StringBuilder sb, int from, boolean forceoneline, boolean cut, int cutLength) {
            int toto = this.length;
            boolean cutting = false;
            if (cut && from + cutLength < this.length) {
                toto = from + cutLength - 3;
                cutting = true;
            }
            if (forceoneline) {
                block4: for (int i = from; i < toto; ++i) {
                    char c = this.chars[i];
                    switch (c) {
                        case '\r': {
                            sb.append("&#13;");
                            continue block4;
                        }
                        case '\n': {
                            sb.append("&#10;");
                            continue block4;
                        }
                        default: {
                            sb.append(c);
                        }
                    }
                }
            } else {
                sb.append(this.chars, from, toto - from);
            }
            if (cutting) {
                sb.append("...");
            }
        }
    }

    private static class StringSource
    implements Source {
        private String xml;
        private int length;

        public StringSource(String xml) {
            this.xml = xml;
            if (!Is.empty(xml)) {
                this.length = xml.length();
            }
        }

        public static StringSource instance(String xml) {
            return new StringSource(xml);
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        public char charAt(int index) {
            return this.xml.charAt(index);
        }

        @Override
        public boolean isEmpty() {
            return this.length == 0;
        }

        @Override
        public String original() {
            return this.xml;
        }

        @Override
        public int indexOf(Token token, int index) {
            return this.xml.indexOf(token.value, index);
        }

        @Override
        public boolean match(Token token, int index) {
            if (index + token.pattern.length >= this.length) {
                return false;
            }
            for (int i = 0; i < token.pattern.length; ++i) {
                char c2;
                char c1 = this.xml.charAt(i + index);
                if (c1 == (c2 = token.pattern[i])) continue;
                return false;
            }
            return true;
        }

        @Override
        public void append(StringBuilder sb, int from, int to, boolean forceoneline, boolean cut, int cutLength) {
            String value = this.xml.substring(from, to);
            boolean cutting = false;
            if (cut && value.length() > cutLength) {
                value = value.substring(0, cutLength - 3);
                cutting = true;
            }
            if (forceoneline) {
                value = value.replace("\r", "&#13;");
                value = value.replace("\n", "&#10;");
            }
            sb.append(value);
            if (cutting) {
                sb.append("...");
            }
        }

        @Override
        public void append(StringBuilder sb, int from, boolean forceoneline, boolean cut, int cutLength) {
            String value = this.xml.substring(from);
            boolean cutting = false;
            if (cut && value.length() > cutLength) {
                value = value.substring(0, cutLength - 3);
                cutting = true;
            }
            if (forceoneline) {
                value = value.replace("\r", "&#13;");
                value = value.replace("\n", "&#10;");
            }
            sb.append(value);
            if (cutting) {
                sb.append("...");
            }
        }
    }

    private static interface Source {
        public int length();

        public char charAt(int var1);

        public boolean isEmpty();

        public String original();

        public int indexOf(Token var1, int var2);

        public boolean match(Token var1, int var2);

        public void append(StringBuilder var1, int var2, int var3, boolean var4, boolean var5, int var6);

        public void append(StringBuilder var1, int var2, boolean var3, boolean var4, int var5);
    }

    private static enum Token {
        LEFT("<"),
        RIGHT(">"),
        LEFT_END("</"),
        RIGHT_SINGLE("/>"),
        CDATA_LEFT("<![CDATA["),
        CDATA_RIGHT("]]>"),
        COMMENT_LEFT("<!--"),
        COMMENT_RIGHT("-->"),
        PROLOG_LEFT("<?"),
        PROLOG_RIGHT("?>");

        private String value;
        private char[] pattern;

        private Token(String value) {
            this.value = value;
            this.pattern = value.toCharArray();
        }

        public int size() {
            return this.pattern.length;
        }
    }

    private static class Position {
        private int index;
        private Token token;
        private boolean nonspacecharacters;

        private Position() {
        }

        public void reset() {
            this.index = -1;
            this.token = null;
            this.nonspacecharacters = false;
        }

        public boolean isValid() {
            return this.index > -1;
        }
    }
}

