/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.json.source;

import java.io.Reader;
import sk.antons.json.source.JsonSource;

public class ReaderSource
implements JsonSource {
    private Reader reader = null;
    int current = -2;
    StringBuilder prev = null;
    StringBuilder sb = null;
    int offset = 0;

    public ReaderSource(Reader reader) {
        if (reader == null) {
            throw new IllegalArgumentException("Unable to parse null Json reader");
        }
        this.reader = reader;
    }

    public static ReaderSource instance(Reader reader) {
        return new ReaderSource(reader);
    }

    private int read() {
        try {
            int i = this.reader.read();
            if (i != -1 && this.sb != null) {
                this.sb.append((char)i);
            }
            return i;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public int current() {
        if (this.current == -2) {
            this.current = this.read();
        }
        return this.current;
    }

    @Override
    public int next() {
        if (this.current == -2) {
            this.current = this.read();
        }
        int rv = this.current;
        this.current = this.read();
        return rv;
    }

    @Override
    public void move() {
        this.next();
    }

    @Override
    public int startRecording() {
        this.sb = new StringBuilder();
        if (this.current > -1) {
            this.sb.append((char)this.current);
        }
        return 0;
    }

    @Override
    public int stopRecording() {
        int rv = this.sb.length() - 1;
        this.prev = this.sb;
        if (this.current == -1) {
            ++rv;
        }
        this.sb = null;
        return rv;
    }

    @Override
    public String recordedContent() {
        return this.prev.toString();
    }
}

