/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.json.source;

import sk.antons.json.source.JsonSource;

public class StringSource
implements JsonSource {
    private String content;
    private int length = -1;
    private int offset = 0;

    public StringSource(String content) {
        if (content == null) {
            content = "";
        }
        this.content = content;
        this.length = content.length();
    }

    public static StringSource instance(String content) {
        return new StringSource(content);
    }

    @Override
    public void move() {
        ++this.offset;
    }

    @Override
    public int current() {
        if (this.offset < this.length) {
            return this.content.charAt(this.offset);
        }
        return -1;
    }

    @Override
    public int next() {
        if (this.offset < this.length) {
            return this.content.charAt(this.offset++);
        }
        return -1;
    }

    @Override
    public int startRecording() {
        return this.offset;
    }

    @Override
    public int stopRecording() {
        return this.offset;
    }

    @Override
    public String recordedContent() {
        return this.content;
    }
}

