/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.json.parse.traversal;

import sk.antons.json.literal.impl.JsonLiteralImpl;
import sk.antons.json.parse.traversal.JsonContentHandler;
import sk.antons.json.parse.traversal.StopTraverse;
import sk.antons.json.source.JsonSource;

public class TraversalParser {
    private JsonSource source;
    private JsonContentHandler handler;
    private boolean started = false;

    public TraversalParser(JsonSource source, JsonContentHandler handler) {
        this.source = source;
        this.handler = handler;
    }

    public static TraversalParser instance(JsonSource source, JsonContentHandler handler) {
        return new TraversalParser(source, handler);
    }

    public void parse() {
        if (this.started) {
            throw new IllegalStateException("parser can be started only once");
        }
        try {
            this.started = true;
            this.handler.startDocument();
            int c = this.source.current();
            while (c != -1) {
                if (c == 123) {
                    this.handler.startObject();
                    this.source.move();
                } else if (c == 125) {
                    this.handler.endObject();
                    this.source.move();
                } else if (c == 91) {
                    this.handler.startArray();
                    this.source.move();
                } else if (c == 93) {
                    this.handler.endArray();
                    this.source.move();
                } else if (c == 58) {
                    this.handler.nameSeparator();
                    this.source.move();
                } else if (c == 44) {
                    this.handler.valueSeparator();
                    this.source.move();
                } else if (this.isWhiteSpace(c)) {
                    this.skipWhiteSpace();
                } else {
                    this.skipLiteral();
                }
                c = this.source.current();
            }
            this.handler.endDocument();
        }
        catch (StopTraverse c) {
        }
        catch (Exception e) {
            String contextInfo = null;
            try {
                contextInfo = this.handler.contextInfo();
            }
            catch (Exception exception) {
                // empty catch block
            }
            String message = "Unable to parse input because of " + e.getMessage();
            if (contextInfo != null) {
                message = message + " [" + contextInfo + "]";
            }
            throw new IllegalArgumentException(message, e);
        }
    }

    private boolean isWhiteSpace(int c) {
        if (c == 32) {
            return true;
        }
        if (c == 9) {
            return true;
        }
        if (c == 10) {
            return true;
        }
        return c == 13;
    }

    private boolean isNonLiteral(int c) {
        if (this.isWhiteSpace(c)) {
            return true;
        }
        if (c == 58) {
            return true;
        }
        if (c == 44) {
            return true;
        }
        if (c == 123) {
            return true;
        }
        if (c == 125) {
            return true;
        }
        if (c == 91) {
            return true;
        }
        return c == 93;
    }

    private void skipWhiteSpace() {
        int startpos = this.source.startRecording();
        int c = this.source.current();
        while (c != -1 && this.isWhiteSpace(c)) {
            this.source.move();
            c = this.source.current();
        }
        int endpos = this.source.stopRecording();
        String str = this.source.recordedContent();
        this.handler.whiteSpace(str, startpos, endpos - startpos);
    }

    private void skipLiteral() {
        int c = this.source.current();
        if (c == 34) {
            this.skipLiteralEscaped();
        } else {
            this.skipLiteralSimple();
        }
    }

    private void skipLiteralSimple() {
        int startpos = this.source.startRecording();
        int c = this.source.current();
        while (c != -1 && !this.isNonLiteral(c)) {
            this.source.move();
            c = this.source.current();
        }
        int endpos = this.source.stopRecording();
        String str = this.source.recordedContent();
        this.handler.literal(JsonLiteralImpl.instance(str, startpos, endpos - startpos));
    }

    private void skipLiteralEscaped() {
        int startpos = this.source.startRecording();
        boolean escape = false;
        this.source.move();
        int c = this.source.current();
        while (c != -1) {
            System.out.println(" " + (char)c + " - " + escape);
            if (escape) {
                escape = false;
            } else if (c == 92) {
                escape = true;
            } else if (c == 34) {
                this.source.move();
                break;
            }
            this.source.move();
            c = this.source.current();
        }
        int endpos = this.source.stopRecording();
        String str = this.source.recordedContent();
        this.handler.literal(JsonLiteralImpl.instance(str, startpos, endpos - startpos));
    }
}

