/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.json.util;

import java.math.BigDecimal;

public class JsonEscaper {
    private static char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private static int fromHex(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        throw new IllegalArgumentException("Can't convert char '" + c + "' to hex number");
    }

    private static char tohex(int c) {
        return hex[c & 0xF];
    }

    public static String escapeChar(int c) {
        char[] arr = new char[6];
        arr[0] = 92;
        arr[1] = 117;
        arr[5] = JsonEscaper.tohex(c);
        arr[4] = JsonEscaper.tohex(c >>= 4);
        arr[3] = JsonEscaper.tohex(c >>= 4);
        arr[2] = JsonEscaper.tohex(c >>= 4);
        return new String(arr);
    }

    public static char unescapeChar(String value) {
        return JsonEscaper.unescapeChar(value, 0);
    }

    public static char unescapeChar(String value, int pos) {
        if (value == null) {
            throw new IllegalArgumentException("Can't unescape string '" + value + "' to char. {Should be \\uHHHH}");
        }
        if (pos + 6 > value.length()) {
            throw new IllegalArgumentException("Can't unescape string '" + value + "' to char. {Should be \\uHHHH} ");
        }
        if (value.charAt(pos) != '\\') {
            throw new IllegalArgumentException("Can't unescape string '" + value + "' to char. {Should be \\uHHHH} ");
        }
        if (value.charAt(pos + 1) != 'u') {
            throw new IllegalArgumentException("Can't unescape string '" + value + "' to char. {Should be \\uHHHH} ");
        }
        int rv = 0;
        int x = JsonEscaper.fromHex(value.charAt(pos + 2));
        rv |= x & 0xF;
        rv <<= 4;
        x = JsonEscaper.fromHex(value.charAt(pos + 3));
        rv |= x & 0xF;
        rv <<= 4;
        x = JsonEscaper.fromHex(value.charAt(pos + 4));
        rv |= x & 0xF;
        rv <<= 4;
        x = JsonEscaper.fromHex(value.charAt(pos + 5));
        return (char)(rv |= x & 0xF);
    }

    public static String escape(String value) {
        return JsonEscaper.escape(value, false);
    }

    public static String escape(String value, boolean escapeNonAscii) {
        if (value == null) {
            return null;
        }
        return JsonEscaper.escape(value, escapeNonAscii, 0, value.length());
    }

    public static String escape(String value, boolean escapeNonAscii, int offset, int length) {
        if (value == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int len = offset + length;
        for (int i = offset; i < len; ++i) {
            char c = value.charAt(i);
            if (c == '\"') {
                sb.append("\\\"");
                continue;
            }
            if (c == '\\') {
                sb.append("\\\\");
                continue;
            }
            if (c == '\n') {
                sb.append("\\n");
                continue;
            }
            if (c == '\t') {
                sb.append("\\t");
                continue;
            }
            if (c == '\r') {
                sb.append("\\r");
                continue;
            }
            if (c == '/') {
                sb.append("\\/");
                continue;
            }
            if (c == '\b') {
                sb.append("\\b");
                continue;
            }
            if (c == '\f') {
                sb.append("\\f");
                continue;
            }
            if (escapeNonAscii && c > '\u007f') {
                sb.append(JsonEscaper.escapeChar(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String unescape(String value) {
        if (value == null) {
            return null;
        }
        return JsonEscaper.unescape(value, 0, value.length());
    }

    public static String unescape(String value, int offset, int length) {
        if (value == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int len = offset + length;
        boolean escape = false;
        for (int i = offset; i < len; ++i) {
            char c = value.charAt(i);
            if (c == '\\') {
                if (escape) {
                    sb.append(c);
                    escape = false;
                    continue;
                }
                escape = true;
                continue;
            }
            if (escape) {
                if (c == 'n') {
                    sb.append('\n');
                } else if (c == '\"') {
                    sb.append('\"');
                } else if (c == 't') {
                    sb.append('\t');
                } else if (c == 'r') {
                    sb.append('\r');
                } else if (c == '/') {
                    sb.append('/');
                } else if (c == 'b') {
                    sb.append('\b');
                } else if (c == 'f') {
                    sb.append('\f');
                } else if (c == 'u') {
                    sb.append(JsonEscaper.unescapeChar(value, i - 1));
                    i += 4;
                } else {
                    throw new IllegalArgumentException("Can't unescape char '" + c + "'");
                }
                escape = false;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static void main(String[] params) {
        String s1 = "+\u013e\u0161\u010d\u0165\u017e\u00fd\u017e\u00fd\u00e1\u00ed\u00e9\u00e9==\u00b4";
        System.out.println(" --- " + s1);
        System.out.println(" --- " + JsonEscaper.unescape(s1));
        System.out.println(" --- " + JsonEscaper.escape(s1, true));
        System.out.println(" --- " + JsonEscaper.unescape(JsonEscaper.escape(s1, true)));
        BigDecimal bd = new BigDecimal("12312.221e4");
        System.out.println(" >>> " + bd.toString());
        System.out.println(" >>> " + bd.toPlainString());
        System.out.println(" >>> " + bd.toEngineeringString());
    }
}

