/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.json.literal.impl;

import sk.antons.json.JsonValue;
import sk.antons.json.literal.JsonStringLiteral;
import sk.antons.json.literal.impl.JsonLiteralImpl;
import sk.antons.json.util.JsonEscaper;

public class JsonStringLiteralImpl
extends JsonLiteralImpl
implements JsonStringLiteral {
    private boolean cachedValue = false;
    private String cachedValueString;

    public JsonStringLiteralImpl(String literal) {
        super(literal);
    }

    public JsonStringLiteralImpl(String literal, int offset, int length) {
        super(literal, offset, length);
    }

    public static JsonStringLiteralImpl fromValue(String value) {
        if (value == null) {
            value = "null";
        }
        value = JsonEscaper.escape(value, true);
        return new JsonStringLiteralImpl("\"" + value + "\"");
    }

    @Override
    public JsonLiteralImpl.Type type() {
        return JsonLiteralImpl.Type.STRING;
    }

    @Override
    public String stringValue() {
        if (this.cachedValue) {
            return this.cachedValueString;
        }
        this.cachedValueString = JsonEscaper.unescape(this.literal, this.offset + 1, this.length - 2);
        this.cachedValue = true;
        return this.cachedValueString;
    }

    @Override
    public JsonValue copy() {
        return new JsonStringLiteralImpl(this.literal, this.offset, this.length);
    }

    @Override
    public Object asTemplateParam() {
        return this.stringValue();
    }
}

