/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.json.parse;

import java.io.Reader;
import java.math.BigDecimal;
import java.util.LinkedList;
import sk.antons.json.source.JsonSource;
import sk.antons.json.source.ReaderSource;
import sk.antons.json.source.StringSource;
import sk.antons.json.util.JsonEscaper;

public class JsonScanner {
    private JsonSource source;
    private Token current;
    private boolean namePossible = false;
    private LinkedList<Container> stack = new LinkedList();
    private boolean isLiteral = false;
    private String buff;
    private int startpos;
    private int endpos;

    public JsonScanner(JsonSource source) {
        this.source = source;
    }

    public static JsonScanner instance(JsonSource source) {
        return new JsonScanner(source);
    }

    public static JsonScanner instance(String json) {
        return new JsonScanner(new StringSource(json));
    }

    public static JsonScanner instance(Reader reader) {
        return new JsonScanner(new ReaderSource(reader));
    }

    public Token current() {
        return this.current;
    }

    public Token next() {
        this.current = this.nextTokenImpl();
        return this.current;
    }

    public String stringValue() {
        return this.stringValueImpl();
    }

    public long intValue() {
        return Long.parseLong(this.stringValueImpl());
    }

    public BigDecimal bdValue() {
        return new BigDecimal(this.stringValueImpl());
    }

    public boolean booleanValue() {
        return "true".equals(this.stringValueImpl());
    }

    private String stringValueImpl() {
        if (this.isLiteral) {
            char c = this.buff.charAt(this.startpos);
            if (c == '\"') {
                return JsonEscaper.unescape(this.buff, this.startpos + 1, this.endpos - this.startpos - 2);
            }
            return this.buff.substring(this.startpos, this.endpos);
        }
        throw new IllegalArgumentException("Current token is not literal");
    }

    private Token nextTokenImpl() {
        try {
            this.isLiteral = false;
            int c = this.source.current();
            while (c != -1) {
                if (c == 123) {
                    this.stack.push(Container.OBJECT);
                    this.namePossible = true;
                    this.source.move();
                    return Token.OBJECT_START;
                }
                if (c == 125) {
                    this.stack.pop();
                    this.namePossible = false;
                    this.source.move();
                    return Token.OBJECT_END;
                }
                if (c == 91) {
                    this.stack.push(Container.ARRAY);
                    this.namePossible = false;
                    this.source.move();
                    return Token.ARRAY_START;
                }
                if (c == 93) {
                    this.stack.pop();
                    this.namePossible = false;
                    this.source.move();
                    return Token.ARRAY_END;
                }
                if (c == 58) {
                    this.namePossible = false;
                    this.source.move();
                } else if (c == 44) {
                    this.namePossible = this.stack.peek() == Container.OBJECT;
                    this.source.move();
                } else if (this.isWhiteSpace(c)) {
                    this.skipWhiteSpace();
                } else {
                    this.skipLiteral();
                    this.isLiteral = true;
                    if (this.namePossible) {
                        return Token.NAME;
                    }
                    return Token.LITERAL;
                }
                c = this.source.current();
            }
            return null;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private boolean isWhiteSpace(int c) {
        if (c == 32) {
            return true;
        }
        if (c == 9) {
            return true;
        }
        if (c == 10) {
            return true;
        }
        return c == 13;
    }

    private boolean isNonLiteral(int c) {
        if (this.isWhiteSpace(c)) {
            return true;
        }
        if (c == 58) {
            return true;
        }
        if (c == 44) {
            return true;
        }
        if (c == 123) {
            return true;
        }
        if (c == 125) {
            return true;
        }
        if (c == 91) {
            return true;
        }
        return c == 93;
    }

    private void skipWhiteSpace() {
        int c = this.source.current();
        while (c != -1 && this.isWhiteSpace(c)) {
            this.source.move();
            c = this.source.current();
        }
    }

    private void skipLiteral() {
        int c = this.source.current();
        if (c == 34) {
            this.skipLiteralEscaped();
        } else {
            this.skipLiteralSimple();
        }
    }

    private void skipLiteralSimple() {
        this.startpos = this.source.startRecording();
        int c = this.source.current();
        while (c != -1 && !this.isNonLiteral(c)) {
            this.source.move();
            c = this.source.current();
        }
        this.endpos = this.source.stopRecording();
        this.buff = this.source.recordedContent();
    }

    private void skipLiteralEscaped() {
        this.startpos = this.source.startRecording();
        boolean escape = false;
        this.source.move();
        int c = this.source.current();
        while (c != -1) {
            if (escape) {
                escape = false;
            } else if (c == 92) {
                escape = true;
            } else if (c == 34) {
                this.source.move();
                break;
            }
            this.source.move();
            c = this.source.current();
        }
        this.endpos = this.source.stopRecording();
        this.buff = this.source.recordedContent();
    }

    private static enum Container {
        OBJECT,
        ARRAY;

    }

    public static enum Token {
        ARRAY_START,
        ARRAY_END,
        OBJECT_START,
        OBJECT_END,
        NAME,
        LITERAL;

    }
}

