/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.json;

import java.math.BigDecimal;
import sk.antons.json.JsonArray;
import sk.antons.json.JsonObject;
import sk.antons.json.impl.JsonArrayImpl;
import sk.antons.json.impl.JsonObjectImpl;
import sk.antons.json.literal.JsonBoolLiteral;
import sk.antons.json.literal.JsonExpLiteral;
import sk.antons.json.literal.JsonFracLiteral;
import sk.antons.json.literal.JsonIntLiteral;
import sk.antons.json.literal.JsonLiteral;
import sk.antons.json.literal.JsonNullLiteral;
import sk.antons.json.literal.JsonStringLiteral;
import sk.antons.json.literal.impl.JsonBoolLiteralImpl;
import sk.antons.json.literal.impl.JsonExpLiteralImpl;
import sk.antons.json.literal.impl.JsonFracLiteralImpl;
import sk.antons.json.literal.impl.JsonIntLiteralImpl;
import sk.antons.json.literal.impl.JsonLiteralImpl;
import sk.antons.json.literal.impl.JsonNullLiteralImpl;
import sk.antons.json.literal.impl.JsonStringLiteralImpl;

public class JsonFactory {
    public static JsonArray array() {
        return new JsonArrayImpl();
    }

    public static JsonObject object() {
        return new JsonObjectImpl();
    }

    public static JsonNullLiteral nullLiteral() {
        return new JsonNullLiteralImpl();
    }

    public static JsonBoolLiteral boolLiteral(boolean value) {
        return new JsonBoolLiteralImpl(value);
    }

    public static JsonExpLiteral expLiteral(BigDecimal value) {
        return new JsonExpLiteralImpl(value);
    }

    public static JsonFracLiteral fracLiteral(BigDecimal value) {
        return new JsonFracLiteralImpl(value);
    }

    public static JsonIntLiteral intLiteral(long value) {
        return new JsonIntLiteralImpl(value);
    }

    public static JsonStringLiteral stringLiteral(String value) {
        return JsonStringLiteralImpl.fromValue(value);
    }

    public static JsonLiteral parseLiteral(String value) {
        return JsonLiteralImpl.instance(value, 0, value.length());
    }
}

