/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.json.match;

import java.util.ArrayList;
import java.util.List;
import sk.antons.json.JsonValue;
import sk.antons.json.match.Match;
import sk.antons.json.match.PathMatcher;

public class SimplePathMatcher
implements PathMatcher {
    private List<String> items = null;

    public SimplePathMatcher(List<String> path) {
        this.items = path;
    }

    public SimplePathMatcher(String ... path) {
        if (path == null) {
            return;
        }
        this.items = new ArrayList<String>();
        for (int i = 0; i < path.length; ++i) {
            this.items.add(path[i]);
        }
    }

    public static SimplePathMatcher instance(List<String> path) {
        return new SimplePathMatcher(path);
    }

    public static SimplePathMatcher instance(String ... path) {
        return new SimplePathMatcher(path);
    }

    @Override
    public Match match(List<String> currentpath, JsonValue currentvalue) {
        if (currentpath == null) {
            return Match.NOPE;
        }
        int len = currentpath.size();
        if (len == 0) {
            return Match.MAYBE;
        }
        if (len > this.items.size()) {
            return Match.NOPE;
        }
        int index = len - 1;
        String current = currentpath.get(index);
        if (current == null) {
            return Match.NOPE;
        }
        String item = this.items.get(index);
        if (current.equals(item) || "*".equals(item)) {
            if (len == this.items.size()) {
                return Match.FULLY;
            }
            return Match.MAYBE;
        }
        return Match.NOPE;
    }
}

