/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.json.match.wild;

import java.util.ArrayList;
import java.util.List;
import sk.antons.json.JsonValue;
import sk.antons.json.match.Match;
import sk.antons.json.match.PathMatcher;
import sk.antons.json.match.PathSplitter;
import sk.antons.json.match.wild.WildMatcher;

public class WildPathMatcher
implements PathMatcher {
    private List<String> items = null;
    private List<Element> elements = new ArrayList<Element>();

    public WildPathMatcher(List<String> path) {
        this.items = path;
        this.init();
    }

    public WildPathMatcher(String ... path) {
        if (path == null) {
            return;
        }
        this.items = new ArrayList<String>();
        for (int i = 0; i < path.length; ++i) {
            this.items.add(path[i]);
        }
        this.init();
    }

    public static WildPathMatcher instance(List<String> path) {
        return new WildPathMatcher(path);
    }

    public static WildPathMatcher instance(String ... path) {
        return new WildPathMatcher(path);
    }

    public static WildPathMatcher fromPath(String path) {
        return new WildPathMatcher(PathSplitter.split(path));
    }

    private void init() {
        for (String item : this.items) {
            if ("**".equals(item)) {
                this.elements.add(AllElement.instance());
                continue;
            }
            this.elements.add(WildElement.instance(item));
        }
    }

    @Override
    public Match match(List<String> currentpath, JsonValue currentvalue) {
        if (currentpath == null) {
            return Match.MAYBE;
        }
        if (currentpath.size() == 0) {
            return Match.MAYBE;
        }
        return this.tryMatch(currentpath, 0, 0);
    }

    public Match tryMatch(List<String> currentpath, int element, int path) {
        if (element >= this.elements.size()) {
            if (path == currentpath.size()) {
                return Match.FULLY;
            }
            if (path < currentpath.size()) {
                return Match.NOPE;
            }
            return Match.MAYBE;
        }
        if (path >= currentpath.size()) {
            return Match.MAYBE;
        }
        Element el = this.elements.get(element);
        int min = el.minLength();
        int max = el.maxLength(currentpath.size() - path);
        Match rv = Match.NOPE;
        for (int i = max; i >= min; --i) {
            String item;
            boolean match = true;
            for (int j = 0; j < i && (match = el.match(item = currentpath.get(path + j))); ++j) {
            }
            if (!match) continue;
            Match result = this.tryMatch(currentpath, element + 1, path + i);
            if (result == Match.FULLY) {
                return result;
            }
            if (result != Match.MAYBE) continue;
            rv = result;
        }
        return rv;
    }

    private static class AllElement
    implements Element {
        public static AllElement instance() {
            return new AllElement();
        }

        @Override
        public boolean match(String value) {
            return true;
        }

        @Override
        public int minLength() {
            return 0;
        }

        @Override
        public int maxLength(int limit) {
            return limit;
        }
    }

    private static class WildElement
    implements Element {
        WildMatcher matcher = null;

        public WildElement(String pattern) {
            this.matcher = WildMatcher.instance(pattern);
        }

        public static WildElement instance(String pattern) {
            return new WildElement(pattern);
        }

        @Override
        public boolean match(String value) {
            return this.matcher.match(value);
        }

        @Override
        public int minLength() {
            return 1;
        }

        @Override
        public int maxLength(int limit) {
            return 1;
        }
    }

    private static interface Element {
        public boolean match(String var1);

        public int minLength();

        public int maxLength(int var1);
    }
}

