/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.json.parse;

import java.io.Reader;
import java.math.BigDecimal;
import java.util.LinkedList;
import sk.antons.json.source.JsonSource;
import sk.antons.json.source.ReaderSource;
import sk.antons.json.source.StringSource;
import sk.antons.json.util.JsonEscaper;

public class JsonScanner {
    private JsonSource source;
    private Token current;
    private boolean namePossible = false;
    private LinkedList<Container> stack = new LinkedList();
    private boolean isLiteral = false;
    private String buff;
    private int startpos;
    private int endpos;

    public JsonScanner(JsonSource source) {
        this.source = source;
    }

    public static JsonScanner instance(JsonSource source) {
        return new JsonScanner(source);
    }

    public static JsonScanner instance(String json) {
        return new JsonScanner(new StringSource(json));
    }

    public static JsonScanner instance(Reader reader) {
        return new JsonScanner(new ReaderSource(reader));
    }

    public Token current() {
        return this.current;
    }

    public Token next() {
        this.current = this.nextTokenImpl();
        return this.current;
    }

    public Token skipNext() {
        int num = 0;
        Token t = null;
        do {
            t = this.next();
            switch (t) {
                case ARRAY_START: {
                    ++num;
                    break;
                }
                case ARRAY_END: {
                    --num;
                    break;
                }
                case OBJECT_START: {
                    ++num;
                    break;
                }
                case OBJECT_END: {
                    --num;
                }
            }
        } while (t != null && num > 0);
        return this.next();
    }

    public String stringValue() {
        return this.stringValueImpl();
    }

    public long intValue() {
        return Long.parseLong(this.stringValueImpl());
    }

    public BigDecimal bdValue() {
        return new BigDecimal(this.stringValueImpl());
    }

    public boolean booleanValue() {
        return "true".equals(this.stringValueImpl());
    }

    private String stringValueImpl() {
        if (this.isLiteral) {
            char c = this.buff.charAt(this.startpos);
            if (c == '\"') {
                return JsonEscaper.unescape(this.buff, this.startpos + 1, this.endpos - this.startpos - 2);
            }
            return this.buff.substring(this.startpos, this.endpos);
        }
        throw new IllegalArgumentException("Current token is not literal");
    }

    private Token nextTokenImpl() {
        try {
            this.isLiteral = false;
            int c = this.source.current();
            while (c != -1) {
                switch (c) {
                    case 123: {
                        this.stack.push(Container.OBJECT);
                        this.namePossible = true;
                        this.source.move();
                        return Token.OBJECT_START;
                    }
                    case 125: {
                        this.stack.pop();
                        this.namePossible = false;
                        this.source.move();
                        return Token.OBJECT_END;
                    }
                    case 91: {
                        this.stack.push(Container.ARRAY);
                        this.namePossible = false;
                        this.source.move();
                        return Token.ARRAY_START;
                    }
                    case 93: {
                        this.stack.pop();
                        this.namePossible = false;
                        this.source.move();
                        return Token.ARRAY_END;
                    }
                    case 58: {
                        this.namePossible = false;
                        this.source.move();
                        break;
                    }
                    case 44: {
                        this.namePossible = this.stack.peek() == Container.OBJECT;
                        this.source.move();
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 13: 
                    case 32: {
                        this.skipWhiteSpace(c);
                        break;
                    }
                    case 34: {
                        this.skipLiteralEscaped(c);
                        this.isLiteral = true;
                        if (this.namePossible) {
                            return Token.NAME;
                        }
                        return Token.LITERAL;
                    }
                    default: {
                        this.skipLiteralSimple(c);
                        this.isLiteral = true;
                        if (this.namePossible) {
                            return Token.NAME;
                        }
                        return Token.LITERAL;
                    }
                }
                c = this.source.current();
            }
            return null;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private boolean isWhiteSpace(int c) {
        switch (c) {
            case 32: {
                return true;
            }
            case 9: {
                return true;
            }
            case 10: {
                return true;
            }
            case 13: {
                return true;
            }
        }
        return false;
    }

    private boolean isNonLiteral(int c) {
        switch (c) {
            case 58: {
                return true;
            }
            case 44: {
                return true;
            }
            case 123: {
                return true;
            }
            case 125: {
                return true;
            }
            case 91: {
                return true;
            }
            case 93: {
                return true;
            }
            case 32: {
                return true;
            }
            case 9: {
                return true;
            }
            case 10: {
                return true;
            }
            case 13: {
                return true;
            }
        }
        return false;
    }

    private void skipWhiteSpace(int c) {
        boolean cont = true;
        block4: while (cont) {
            switch (c) {
                case -1: {
                    cont = false;
                    break block4;
                }
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    break;
                }
                default: {
                    cont = false;
                    break block4;
                }
            }
            this.source.move();
            c = this.source.current();
        }
    }

    private void skipLiteral(int c) {
        if (c == 34) {
            this.skipLiteralEscaped(c);
        } else {
            this.skipLiteralSimple(c);
        }
    }

    private void skipLiteralSimple(int c) {
        this.startpos = this.source.startRecording();
        boolean cont = true;
        block4: while (cont) {
            switch (c) {
                case -1: {
                    cont = false;
                    break block4;
                }
                case 9: 
                case 10: 
                case 13: 
                case 32: 
                case 44: 
                case 58: 
                case 91: 
                case 93: 
                case 123: 
                case 125: {
                    cont = false;
                    break block4;
                }
                default: {
                    this.source.move();
                    c = this.source.current();
                    continue block4;
                }
            }
        }
        this.endpos = this.source.stopRecording();
        this.buff = this.source.recordedContent();
    }

    /*
     * Unable to fully structure code
     */
    private void skipLiteralEscaped(int c) {
        this.startpos = this.source.startRecording();
        escape = false;
        this.source.move();
        c = this.source.current();
        block4: while (c != -1) {
            block5: {
                if (!escape) break block5;
                escape = false;
                ** GOTO lbl-1000
            }
            switch (c) {
                case 92: {
                    escape = true;
                }
                case 34: {
                    this.source.move();
                    break block4;
                }
                default: lbl-1000:
                // 2 sources

                {
                    this.source.move();
                    c = this.source.current();
                    continue block4;
                }
            }
        }
        this.endpos = this.source.stopRecording();
        this.buff = this.source.recordedContent();
    }

    private static enum Container {
        OBJECT,
        ARRAY;

    }

    public static enum Token {
        ARRAY_START,
        ARRAY_END,
        OBJECT_START,
        OBJECT_END,
        NAME,
        LITERAL;

    }
}

